/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf;

import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWAttribute;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWForm;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWTag;
import java.util.List;

public class DebugAbbrevEntry {
    public final int number;
    public final DWTag tag;
    public final boolean hasChildren;
    public final List<Attribute> attributes;

    public DebugAbbrevEntry(int number, int tag, boolean hasChildren, List<Attribute> attributes) {
        this.number = number;
        this.tag = DWTag.fromValue(tag);
        this.hasChildren = hasChildren;
        this.attributes = attributes;
    }

    public String toString() {
        String hasChildrenString = this.hasChildren ? "[has children]" : "[no children]";
        StringBuilder sb = new StringBuilder(this.number + "\t" + (Object)((Object)this.tag) + "\t" + hasChildrenString + "\n");
        for (Attribute attr : this.attributes) {
            sb.append("  ").append(attr).append("\n");
        }
        return sb.toString();
    }

    public static class Attribute {
        public final DWAttribute name;
        public final DWForm form;

        public Attribute(int name, int type) {
            this.name = DWAttribute.fromValue(name);
            this.form = DWForm.fromValue(type);
        }

        public String toString() {
            return (Object)((Object)this.name) + "\t" + (Object)((Object)this.form);
        }
    }
}

