/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.mappingfiles;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.mappingfiles.XmlResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class MappingFileIdReader {
    protected final DocumentBuilder docBuilder;

    public static MappingFileIdReader create(File resourceFile) {
        try {
            return new FileIdReader(resourceFile, DocumentBuilderFactory.newInstance().newDocumentBuilder());
        }
        catch (ParserConfigurationException e) {
            Buildtools.logE("Crashlytics experienced an unrecoverable parser configuration exception", e);
            throw new RuntimeException(e);
        }
    }

    public static MappingFileIdReader create(String xmlString) {
        try {
            return new StringIdReader(xmlString, DocumentBuilderFactory.newInstance().newDocumentBuilder());
        }
        catch (ParserConfigurationException e) {
            Buildtools.logE("Crashlytics experienced an unrecoverable parser configuration exception", e);
            throw new RuntimeException(e);
        }
    }

    protected abstract Document parseXmlSource() throws SAXException, IOException;

    protected MappingFileIdReader(DocumentBuilder builder) {
        this.docBuilder = builder;
    }

    protected DocumentBuilder getDocumentBuilder() {
        return this.docBuilder;
    }

    public String getMappingFileId() throws IOException {
        String toReturn = null;
        try {
            Document doc = this.parseXmlSource();
            if (doc == null) {
                return null;
            }
            Element idElement = XmlResourceUtils.getMappingFileIdElement(doc);
            if (idElement != null) {
                toReturn = idElement.getTextContent();
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return toReturn;
    }

    private static class StringIdReader
    extends MappingFileIdReader {
        private final String string;

        StringIdReader(String xmlString, DocumentBuilder docBuilder) {
            super(docBuilder);
            this.string = xmlString;
        }

        @Override
        protected Document parseXmlSource() throws IOException, SAXException {
            if (this.string == null || this.string.isEmpty()) {
                return null;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(this.string.getBytes(StandardCharsets.UTF_8));
            return this.getDocumentBuilder().parse(stream);
        }
    }

    private static class FileIdReader
    extends MappingFileIdReader {
        private final File file;

        FileIdReader(File xmlFile, DocumentBuilder docBuilder) {
            super(docBuilder);
            this.file = xmlFile;
        }

        @Override
        protected Document parseXmlSource() throws IOException, SAXException {
            if (!this.file.exists()) {
                return null;
            }
            return this.getDocumentBuilder().parse(this.file);
        }
    }
}

