/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsVariantExtension;
import com.google.firebase.crashlytics.buildtools.gradle.SymbolGeneratorType;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad.BreakpadSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.NdkCSymGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eH\u0002J \u0010 \u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "breakpadBinary", "Lorg/gradle/api/file/RegularFileProperty;", "getBreakpadBinary", "()Lorg/gradle/api/file/RegularFileProperty;", "breakpadExtractionDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBreakpadExtractionDir", "()Lorg/gradle/api/file/DirectoryProperty;", "symbolFileOutputDir", "getSymbolFileOutputDir", "symbolGeneratorType", "Lorg/gradle/api/provider/Property;", "Lcom/google/firebase/crashlytics/buildtools/gradle/SymbolGeneratorType;", "getSymbolGeneratorType", "()Lorg/gradle/api/provider/Property;", "unstrippedNativeLibsDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getUnstrippedNativeLibsDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "generateSymbolFiles", "", "printDebugProperties", "resolveBreakpadBinary", "Ljava/io/File;", "validateSymbolGeneratorType", "project", "Lorg/gradle/api/Project;", "symbolGeneratorTypeOverride", "", "validateUnstrippedNativeLibsDirs", "variant", "Lcom/android/build/api/variant/Variant;", "unstrippedNativeLibsOverride", "Companion", "crashlytics-gradle"})
@SourceDebugExtension(value={"SMAP\nGenerateSymbolFileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSymbolFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1755#2,3:203\n1611#2,9:206\n1863#2:215\n1864#2:217\n1620#2:218\n1#3:216\n*S KotlinDebug\n*F\n+ 1 GenerateSymbolFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask\n*L\n104#1:203,3\n110#1:206,9\n110#1:215\n110#1:217\n110#1:218\n110#1:216\n*E\n"})
public abstract class GenerateSymbolFileTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SYMBOL_GENERATOR_PROPERTY = "com.google.firebase.crashlytics.symbolGenerator";
    @NotNull
    private static final String BREAKPAD_BINARY_PROPERTY = "com.google.firebase.crashlytics.breakpadBinary";

    public GenerateSymbolFileTask() {
        this.setGroup("Firebase Crashlytics");
        this.setDescription("Generate native symbol file used by Crashlytics to symbolicate native (NDK) stack traces");
    }

    @InputFiles
    @SkipWhenEmpty
    @NotNull
    public abstract ConfigurableFileCollection getUnstrippedNativeLibsDirs();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getBreakpadBinary();

    @Internal
    @NotNull
    public abstract Property<SymbolGeneratorType> getSymbolGeneratorType();

    @Internal
    @NotNull
    public abstract DirectoryProperty getBreakpadExtractionDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSymbolFileOutputDir();

    @TaskAction
    public final void generateSymbolFiles() {
        Object object = this.getSymbolGeneratorType().get();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.firebase.crashlytics.buildtools.gradle.SymbolGeneratorType");
        NativeSymbolGenerator generator = switch (WhenMappings.$EnumSwitchMapping$0[((SymbolGeneratorType)((Object)object)).ordinal()]) {
            case 1 -> new BreakpadSymbolGenerator(this.resolveBreakpadBinary());
            case 2 -> new NdkCSymGenerator();
            default -> throw new NoWhenBranchMatchedException();
        };
        for (File unstrippedNativeLibsDir : this.getUnstrippedNativeLibsDirs().getFiles()) {
            Intrinsics.checkNotNullExpressionValue((Object)unstrippedNativeLibsDir, (String)"unstrippedNativeLibsDir");
            File file = ((Directory)this.getSymbolFileOutputDir().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"symbolFileOutputDir.get().asFile");
            CrashlyticsBuildtools.INSTANCE.generateNativeSymbolFiles(unstrippedNativeLibsDir, file, generator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUnstrippedNativeLibsDirs(Project project, Variant variant, ConfigurableFileCollection unstrippedNativeLibsOverride) {
        File it;
        boolean bl;
        String mergedNativeLibsOutput;
        block9: {
            if (unstrippedNativeLibsOverride.isEmpty()) {
                Object[] objectArray = new Object[]{variant.getArtifacts().get((SingleArtifact)SingleArtifact.MERGED_NATIVE_LIBS.INSTANCE)};
                this.getUnstrippedNativeLibsDirs().setFrom(objectArray);
                return;
            }
            mergedNativeLibsOutput = "build/intermediates/merged_native_libs/" + variant.getName() + "/out";
            Iterable $this$any$iv = (Iterable)unstrippedNativeLibsOverride;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (File)element$iv;
                    boolean bl2 = false;
                    String string = it.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)mergedNativeLibsOutput, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapNotNullTo$iv$iv;
            Object[] $this$mapNotNull$iv;
            String mergedNativeLibsTask = "merge" + StringExtensionsKt.capitalized(variant.getName()) + "NativeLibs";
            Set set = unstrippedNativeLibsOverride.getBuildDependencies().getDependencies(null);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"unstrippedNativeLibsOver\u2026   .getDependencies(null)");
            Iterable iterable = set;
            boolean $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                Task it2 = (Task)element$iv$iv;
                boolean bl4 = false;
                Task task = it2;
                if ((task != null ? task.getName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set dependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (!dependencies.contains(mergedNativeLibsTask)) {
                try {
                    $this$mapNotNull$iv = new Object[]{project.getTasks().getByPath(mergedNativeLibsTask)};
                    this.dependsOn($this$mapNotNull$iv);
                }
                catch (UnknownTaskException ex) {
                    this.getLogger().warn("The unstrippedNativeLibsDir manually overridden to output of " + mergedNativeLibsTask + " task. This is not necessary, it is safe to remove " + mergedNativeLibsOutput + " from the unstrippedNativeLibsDir override.");
                }
            }
        }
        this.getUnstrippedNativeLibsDirs().setFrom((Iterable)unstrippedNativeLibsOverride);
    }

    private final void validateSymbolGeneratorType(Project project, Property<String> symbolGeneratorTypeOverride) {
        String string;
        if (project.hasProperty(SYMBOL_GENERATOR_PROPERTY)) {
            Object object = project.findProperty(SYMBOL_GENERATOR_PROPERTY);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        } else {
            string = symbolGeneratorTypeOverride.isPresent() ? (String)symbolGeneratorTypeOverride.get() : "breakpad";
        }
        String symbolGeneratorTypeString = string;
        Property<SymbolGeneratorType> property = this.getSymbolGeneratorType();
        Intrinsics.checkNotNullExpressionValue((Object)symbolGeneratorTypeString, (String)"symbolGeneratorTypeString");
        property.set((Object)SymbolGeneratorType.Companion.fromString(symbolGeneratorTypeString));
    }

    private final File resolveBreakpadBinary() {
        if (this.getBreakpadBinary().isPresent()) {
            File file = ((RegularFile)this.getBreakpadBinary().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"breakpadBinary.get().asFile");
            return file;
        }
        File extractionDir = ((Directory)this.getBreakpadExtractionDir().get()).getAsFile();
        extractionDir.mkdirs();
        File file = BreakpadSymbolGenerator.extractDefaultDumpSymsBinary(extractionDir);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"extractDefaultDumpSymsBinary(extractionDir)");
        return file;
    }

    private final void printDebugProperties() {
        Object object;
        Object object2;
        Object object3;
        this.getLogger().debug("GenerateSymbolFileTask:");
        this.getLogger().debug("  unstrippedNativeLibsDirs: " + this.getUnstrippedNativeLibsDirs().getAsPath());
        this.getLogger().debug("  breakpadBinary: " + ((object3 = (RegularFile)this.getBreakpadBinary().getOrNull()) != null && (object3 = object3.getAsFile()) != null ? ((File)object3).getPath() : null));
        SymbolGeneratorType symbolGeneratorType = (SymbolGeneratorType)((Object)this.getSymbolGeneratorType().getOrNull());
        this.getLogger().debug("  symbolGeneratorType: " + (symbolGeneratorType != null ? symbolGeneratorType.toString() : null));
        this.getLogger().debug("  breakpadExtractionDir: " + ((object2 = (Directory)this.getBreakpadExtractionDir().getOrNull()) != null && (object2 = object2.getAsFile()) != null ? ((File)object2).getPath() : null));
        this.getLogger().debug("  symbolFileOutputDir: " + ((object = (Directory)this.getSymbolFileOutputDir().getOrNull()) != null && (object = object.getAsFile()) != null ? ((File)object).getPath() : null));
    }

    public static final /* synthetic */ void access$validateUnstrippedNativeLibsDirs(GenerateSymbolFileTask $this, Project project, Variant variant, ConfigurableFileCollection unstrippedNativeLibsOverride) {
        $this.validateUnstrippedNativeLibsDirs(project, variant, unstrippedNativeLibsOverride);
    }

    public static final /* synthetic */ void access$validateSymbolGeneratorType(GenerateSymbolFileTask $this, Project project, Property symbolGeneratorTypeOverride) {
        $this.validateSymbolGeneratorType(project, (Property<String>)symbolGeneratorTypeOverride);
    }

    public static final /* synthetic */ void access$printDebugProperties(GenerateSymbolFileTask $this) {
        $this.printDebugProperties();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SymbolGeneratorType.values().length];
            try {
                nArray[SymbolGeneratorType.BREAKPAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolGeneratorType.CSYM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask$Companion;", "", "()V", "BREAKPAD_BINARY_PROPERTY", "", "SYMBOL_GENERATOR_PROPERTY", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "crashlyticsExtension", "Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsVariantExtension;", "crashlytics-gradle"})
    @SourceDebugExtension(value={"SMAP\nGenerateSymbolFileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSymbolFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask$Companion\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,202:1\n263#2:203\n*S KotlinDebug\n*F\n+ 1 GenerateSymbolFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask$Companion\n*L\n170#1:203\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<GenerateSymbolFileTask> register(@NotNull Project project, @NotNull Variant variant, @NotNull CrashlyticsVariantExtension crashlyticsExtension) {
            void name$iv;
            void $this$register$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)crashlyticsExtension, (String)"crashlyticsExtension");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer taskContainer2 = taskContainer;
            String string = "generateCrashlyticsSymbolFile" + StringExtensionsKt.capitalized(variant.getName());
            Function1 configuration$iv = (Function1)new Function1<GenerateSymbolFileTask, Unit>(project, crashlyticsExtension, variant){
                final /* synthetic */ Project $project;
                final /* synthetic */ CrashlyticsVariantExtension $crashlyticsExtension;
                final /* synthetic */ Variant $variant;
                {
                    this.$project = $project;
                    this.$crashlyticsExtension = $crashlyticsExtension;
                    this.$variant = $variant;
                    super(1);
                }

                public final void invoke(@NotNull GenerateSymbolFileTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    if (this.$project.hasProperty("com.google.firebase.crashlytics.breakpadBinary")) {
                        RegularFileProperty regularFileProperty = $this$register.getBreakpadBinary();
                        Object object = this.$project.findProperty("com.google.firebase.crashlytics.breakpadBinary");
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                        regularFileProperty.set(new File((String)object));
                    } else {
                        $this$register.getBreakpadBinary().set((Provider)this.$crashlyticsExtension.getBreakpadBinary());
                    }
                    $this$register.getBreakpadExtractionDir().set(CrashlyticsPlugin.Companion.buildDir(this.$project, this.$variant, "dump_syms"));
                    $this$register.getSymbolFileOutputDir().set(CrashlyticsPlugin.Companion.buildDir(this.$project, this.$variant, "nativeSymbols"));
                    GenerateSymbolFileTask.access$validateUnstrippedNativeLibsDirs($this$register, this.$project, this.$variant, this.$crashlyticsExtension.getUnstrippedNativeLibsOverride());
                    GenerateSymbolFileTask.access$validateSymbolGeneratorType($this$register, this.$project, this.$crashlyticsExtension.getSymbolGeneratorType());
                    GenerateSymbolFileTask.access$printDebugProperties($this$register);
                }
            };
            boolean $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register((String)name$iv, GenerateSymbolFileTask.class, new Action(configuration$iv){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
            return taskProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

