/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.elf;

public final class ElfFileIdent {
    public static final int EI_NIDENT = 16;
    public static final int ELFCLASSNONE = 0;
    public static final int ELFCLASS32 = 1;
    public static final int ELFCLASS64 = 2;
    public static final int ELFDATANONE = 0;
    public static final int ELFDATA2LSB = 1;
    public static final int ELFDATA2MSB = 2;
    private static final byte[] EI_MAG = new byte[]{127, 69, 76, 70};
    private static final int EI_CLASS = 4;
    private static final int EI_DATA = 5;
    private static final int EI_VERSION = 6;
    private static final int EI_OSABI = 7;
    private static final int EI_ABIVERSION = 8;
    private final byte[] _identBuffer;

    public ElfFileIdent(byte[] identBuffer) {
        this._identBuffer = identBuffer;
    }

    public int getElfClass() {
        return this._identBuffer[4];
    }

    public int getDataEncoding() {
        return this._identBuffer[5];
    }

    public int getElfVersion() {
        return this._identBuffer[6];
    }

    public int getOSABI() {
        return this._identBuffer[7];
    }

    public int getABIVersion() {
        return this._identBuffer[8];
    }

    public boolean isElf() {
        for (int i2 = 0; i2 < EI_MAG.length; ++i2) {
            if (EI_MAG[i2] == this._identBuffer[i2]) continue;
            return false;
        }
        return true;
    }
}

