/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.analytics;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsReceiver;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsConnectorReceiver
implements AnalyticsConnector.AnalyticsConnectorListener,
AnalyticsReceiver {
    static final String CRASHLYTICS_ORIGIN = "clx";
    public static final String EVENT_NAME_KEY = "name";
    public static final String APP_EXCEPTION_EVENT_NAME = "_ae";
    private static final String EVENT_ORIGIN_KEY = "_o";
    private static final String EVENT_PARAMS_KEY = "params";
    private static final String BREADCRUMB_PARAMS_KEY = "parameters";
    private static final String BREADCRUMB_PREFIX = "$A$:";
    private final AnalyticsConnector analyticsConnector;
    private final BreadcrumbHandler breadcrumbHandler;
    private AnalyticsReceiver.CrashlyticsOriginEventListener crashOriginEventListener;
    private AnalyticsConnector.AnalyticsConnectorHandle analyticsConnectorHandle;

    public AnalyticsConnectorReceiver(AnalyticsConnector analyticsConnector, BreadcrumbHandler breadcrumbHandler) {
        this.analyticsConnector = analyticsConnector;
        this.breadcrumbHandler = breadcrumbHandler;
    }

    @Override
    public boolean register() {
        if (this.analyticsConnector == null) {
            Logger.getLogger().d("FirebaseCrashlytics", "Firebase Analytics is not present; you will not see automatic logging of events before a crash occurs.");
            return false;
        }
        this.analyticsConnectorHandle = this.analyticsConnector.registerAnalyticsConnectorListener(CRASHLYTICS_ORIGIN, (AnalyticsConnector.AnalyticsConnectorListener)this);
        return this.analyticsConnectorHandle != null;
    }

    @Override
    public void unregister() {
        if (this.analyticsConnectorHandle != null) {
            this.analyticsConnectorHandle.unregister();
        }
    }

    @Override
    public void setCrashlyticsOriginEventListener(@Nullable AnalyticsReceiver.CrashlyticsOriginEventListener listener) {
        this.crashOriginEventListener = listener;
    }

    @Override
    @Nullable
    public AnalyticsReceiver.CrashlyticsOriginEventListener getCrashlyticsOriginEventListener() {
        return this.crashOriginEventListener;
    }

    public void onMessageTriggered(int id, @Nullable Bundle extras) {
        String origin;
        Logger.getLogger().d("FirebaseCrashlytics", "AnalyticsConnectorReceiver received message: " + id + " " + extras);
        if (extras == null) {
            return;
        }
        Bundle params = extras.getBundle(EVENT_PARAMS_KEY);
        if (params == null) {
            params = new Bundle();
        }
        if (CRASHLYTICS_ORIGIN.equals(origin = params.getString(EVENT_ORIGIN_KEY))) {
            this.dispatchCrashlyticsOriginEvent(id, extras);
        } else {
            String name = extras.getString(EVENT_NAME_KEY);
            if (name != null) {
                this.dispatchBreadcrumbEvent(name, params);
            }
        }
    }

    private void dispatchCrashlyticsOriginEvent(int id, @Nullable Bundle extras) {
        if (this.crashOriginEventListener != null) {
            this.crashOriginEventListener.onCrashlyticsOriginEvent(id, extras);
        }
    }

    private void dispatchBreadcrumbEvent(String name, Bundle params) {
        try {
            String serializedEvent = BREADCRUMB_PREFIX + AnalyticsConnectorReceiver.serializeEvent(name, params);
            this.breadcrumbHandler.dropBreadcrumb(serializedEvent);
        }
        catch (JSONException e) {
            Logger.getLogger().w("FirebaseCrashlytics", "Unable to serialize Firebase Analytics event.");
        }
    }

    private static String serializeEvent(@NonNull String name, @NonNull Bundle params) throws JSONException {
        JSONObject enclosingObject = new JSONObject();
        JSONObject paramsObject = new JSONObject();
        for (String key : params.keySet()) {
            paramsObject.put(key, params.get(key));
        }
        enclosingObject.put(EVENT_NAME_KEY, (Object)name);
        enclosingObject.put(BREADCRUMB_PARAMS_KEY, (Object)paramsObject);
        return enclosingObject.toString();
    }

    public static interface BreadcrumbHandler {
        public void dropBreadcrumb(String var1);
    }
}

