/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.encoders.annotations.Encodable;

final class AutoValue_CrashlyticsReport_Session
extends CrashlyticsReport.Session {
    private final String generator;
    private final String identifier;
    private final long startedAt;
    private final Long endedAt;
    private final boolean crashed;
    private final CrashlyticsReport.Session.Application app;
    private final CrashlyticsReport.Session.User user;
    private final CrashlyticsReport.Session.OperatingSystem os;
    private final CrashlyticsReport.Session.Device device;
    private final ImmutableList<CrashlyticsReport.Session.Event> events;
    private final int generatorType;

    private AutoValue_CrashlyticsReport_Session(String generator, String identifier, long startedAt, @Nullable Long endedAt, boolean crashed, CrashlyticsReport.Session.Application app, @Nullable CrashlyticsReport.Session.User user, @Nullable CrashlyticsReport.Session.OperatingSystem os, @Nullable CrashlyticsReport.Session.Device device, @Nullable ImmutableList<CrashlyticsReport.Session.Event> events, int generatorType) {
        this.generator = generator;
        this.identifier = identifier;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.crashed = crashed;
        this.app = app;
        this.user = user;
        this.os = os;
        this.device = device;
        this.events = events;
        this.generatorType = generatorType;
    }

    @Override
    @NonNull
    public String getGenerator() {
        return this.generator;
    }

    @Override
    @Encodable.Ignore
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public long getStartedAt() {
        return this.startedAt;
    }

    @Override
    @Nullable
    public Long getEndedAt() {
        return this.endedAt;
    }

    @Override
    public boolean isCrashed() {
        return this.crashed;
    }

    @Override
    @NonNull
    public CrashlyticsReport.Session.Application getApp() {
        return this.app;
    }

    @Override
    @Nullable
    public CrashlyticsReport.Session.User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public CrashlyticsReport.Session.OperatingSystem getOs() {
        return this.os;
    }

    @Override
    @Nullable
    public CrashlyticsReport.Session.Device getDevice() {
        return this.device;
    }

    @Override
    @Nullable
    public ImmutableList<CrashlyticsReport.Session.Event> getEvents() {
        return this.events;
    }

    @Override
    public int getGeneratorType() {
        return this.generatorType;
    }

    public String toString() {
        return "Session{generator=" + this.generator + ", identifier=" + this.identifier + ", startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ", crashed=" + this.crashed + ", app=" + this.app + ", user=" + this.user + ", os=" + this.os + ", device=" + this.device + ", events=" + this.events + ", generatorType=" + this.generatorType + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CrashlyticsReport.Session) {
            CrashlyticsReport.Session that = (CrashlyticsReport.Session)o;
            return this.generator.equals(that.getGenerator()) && this.identifier.equals(that.getIdentifier()) && this.startedAt == that.getStartedAt() && (this.endedAt == null ? that.getEndedAt() == null : this.endedAt.equals(that.getEndedAt())) && this.crashed == that.isCrashed() && this.app.equals(that.getApp()) && (this.user == null ? that.getUser() == null : this.user.equals(that.getUser())) && (this.os == null ? that.getOs() == null : this.os.equals(that.getOs())) && (this.device == null ? that.getDevice() == null : this.device.equals(that.getDevice())) && (this.events == null ? that.getEvents() == null : this.events.equals(that.getEvents())) && this.generatorType == that.getGeneratorType();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.generator.hashCode();
        h$ *= 1000003;
        h$ ^= this.identifier.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.startedAt >>> 32 ^ this.startedAt);
        h$ *= 1000003;
        h$ ^= this.endedAt == null ? 0 : this.endedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.crashed ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.app.hashCode();
        h$ *= 1000003;
        h$ ^= this.user == null ? 0 : this.user.hashCode();
        h$ *= 1000003;
        h$ ^= this.os == null ? 0 : this.os.hashCode();
        h$ *= 1000003;
        h$ ^= this.device == null ? 0 : this.device.hashCode();
        h$ *= 1000003;
        h$ ^= this.events == null ? 0 : this.events.hashCode();
        h$ *= 1000003;
        return h$ ^= this.generatorType;
    }

    @Override
    public CrashlyticsReport.Session.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CrashlyticsReport.Session.Builder {
        private String generator;
        private String identifier;
        private Long startedAt;
        private Long endedAt;
        private Boolean crashed;
        private CrashlyticsReport.Session.Application app;
        private CrashlyticsReport.Session.User user;
        private CrashlyticsReport.Session.OperatingSystem os;
        private CrashlyticsReport.Session.Device device;
        private ImmutableList<CrashlyticsReport.Session.Event> events;
        private Integer generatorType;

        Builder() {
        }

        private Builder(CrashlyticsReport.Session source) {
            this.generator = source.getGenerator();
            this.identifier = source.getIdentifier();
            this.startedAt = source.getStartedAt();
            this.endedAt = source.getEndedAt();
            this.crashed = source.isCrashed();
            this.app = source.getApp();
            this.user = source.getUser();
            this.os = source.getOs();
            this.device = source.getDevice();
            this.events = source.getEvents();
            this.generatorType = source.getGeneratorType();
        }

        @Override
        public CrashlyticsReport.Session.Builder setGenerator(String generator) {
            if (generator == null) {
                throw new NullPointerException("Null generator");
            }
            this.generator = generator;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setIdentifier(String identifier) {
            if (identifier == null) {
                throw new NullPointerException("Null identifier");
            }
            this.identifier = identifier;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setStartedAt(long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setEndedAt(Long endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setCrashed(boolean crashed) {
            this.crashed = crashed;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setApp(CrashlyticsReport.Session.Application app) {
            if (app == null) {
                throw new NullPointerException("Null app");
            }
            this.app = app;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setUser(CrashlyticsReport.Session.User user) {
            this.user = user;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setOs(CrashlyticsReport.Session.OperatingSystem os) {
            this.os = os;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setDevice(CrashlyticsReport.Session.Device device) {
            this.device = device;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setEvents(ImmutableList<CrashlyticsReport.Session.Event> events) {
            this.events = events;
            return this;
        }

        @Override
        public CrashlyticsReport.Session.Builder setGeneratorType(int generatorType) {
            this.generatorType = generatorType;
            return this;
        }

        @Override
        public CrashlyticsReport.Session build() {
            String missing = "";
            if (this.generator == null) {
                missing = missing + " generator";
            }
            if (this.identifier == null) {
                missing = missing + " identifier";
            }
            if (this.startedAt == null) {
                missing = missing + " startedAt";
            }
            if (this.crashed == null) {
                missing = missing + " crashed";
            }
            if (this.app == null) {
                missing = missing + " app";
            }
            if (this.generatorType == null) {
                missing = missing + " generatorType";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CrashlyticsReport_Session(this.generator, this.identifier, this.startedAt, this.endedAt, this.crashed, this.app, this.user, this.os, this.device, this.events, this.generatorType);
        }
    }
}

