/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.Utils;

public class DataCollectionArbiter {
    private static final String FIREBASE_CRASHLYTICS_COLLECTION_ENABLED = "firebase_crashlytics_collection_enabled";
    private final SharedPreferences sharedPreferences;
    private final FirebaseApp firebaseApp;
    private final Object taskLock = new Object();
    TaskCompletionSource<Void> dataCollectionEnabledTask = new TaskCompletionSource();
    boolean taskResolved = false;
    private boolean setInManifest = false;
    @Nullable
    private Boolean crashlyticsDataCollectionEnabled;
    private TaskCompletionSource<Void> dataCollectionExplicitlyApproved = new TaskCompletionSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollectionArbiter(FirebaseApp app) {
        Context applicationContext = app.getApplicationContext();
        this.firebaseApp = app;
        this.sharedPreferences = CommonUtils.getSharedPrefs(applicationContext);
        Boolean dataCollectionEnabled = this.getDataCollectionValueFromSharedPreferences();
        if (dataCollectionEnabled == null) {
            dataCollectionEnabled = this.getDataCollectionValueFromManifest(applicationContext);
        }
        this.crashlyticsDataCollectionEnabled = dataCollectionEnabled;
        Object object = this.taskLock;
        synchronized (object) {
            if (this.isAutomaticDataCollectionEnabled()) {
                this.dataCollectionEnabledTask.trySetResult(null);
                this.taskResolved = true;
            }
        }
    }

    public synchronized boolean isAutomaticDataCollectionEnabled() {
        boolean dataCollectionEnabled = this.crashlyticsDataCollectionEnabled != null ? this.crashlyticsDataCollectionEnabled.booleanValue() : this.firebaseApp.isDataCollectionDefaultEnabled();
        this.logDataCollectionState(dataCollectionEnabled);
        return dataCollectionEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCrashlyticsDataCollectionEnabled(@Nullable Boolean enabled) {
        this.crashlyticsDataCollectionEnabled = enabled != null ? enabled : this.getDataCollectionValueFromManifest(this.firebaseApp.getApplicationContext());
        DataCollectionArbiter.storeDataCollectionValueInSharedPreferences(this.sharedPreferences, enabled);
        Object object = this.taskLock;
        synchronized (object) {
            if (this.isAutomaticDataCollectionEnabled()) {
                if (!this.taskResolved) {
                    this.dataCollectionEnabledTask.trySetResult(null);
                    this.taskResolved = true;
                }
            } else if (this.taskResolved) {
                this.dataCollectionEnabledTask = new TaskCompletionSource();
                this.taskResolved = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> waitForAutomaticDataCollectionEnabled() {
        Object object = this.taskLock;
        synchronized (object) {
            return this.dataCollectionEnabledTask.getTask();
        }
    }

    public Task<Void> waitForDataCollectionPermission() {
        return Utils.race(this.dataCollectionExplicitlyApproved.getTask(), this.waitForAutomaticDataCollectionEnabled());
    }

    public void grantDataCollectionPermission(boolean dataCollectionToken) {
        if (!dataCollectionToken) {
            throw new IllegalStateException("An invalid data collection token was used.");
        }
        this.dataCollectionExplicitlyApproved.trySetResult(null);
    }

    private void logDataCollectionState(boolean dataCollectionEnabled) {
        String stateString;
        String string = stateString = dataCollectionEnabled ? "ENABLED" : "DISABLED";
        String fromString = this.crashlyticsDataCollectionEnabled == null ? "global Firebase setting" : (this.setInManifest ? "firebase_crashlytics_collection_enabled manifest flag" : "API");
        Logger.getLogger().d(String.format("Crashlytics automatic data collection %s by %s.", stateString, fromString));
    }

    @Nullable
    private Boolean getDataCollectionValueFromSharedPreferences() {
        if (this.sharedPreferences.contains(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED)) {
            this.setInManifest = false;
            return this.sharedPreferences.getBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED, true);
        }
        return null;
    }

    @Nullable
    private Boolean getDataCollectionValueFromManifest(Context applicationContext) {
        Boolean manifestSetting = DataCollectionArbiter.readCrashlyticsDataCollectionEnabledFromManifest(applicationContext);
        if (manifestSetting == null) {
            this.setInManifest = false;
            return null;
        }
        this.setInManifest = true;
        return Boolean.TRUE.equals(manifestSetting);
    }

    @Nullable
    private static Boolean readCrashlyticsDataCollectionEnabledFromManifest(Context applicationContext) {
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = applicationContext.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(applicationContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED)) {
                return applicationInfo.metaData.getBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.getLogger().d("Unable to get PackageManager. Falling through", e);
        }
        return null;
    }

    @SuppressLint(value={"ApplySharedPref"})
    private static void storeDataCollectionValueInSharedPreferences(SharedPreferences sharedPreferences, Boolean enabled) {
        SharedPreferences.Editor prefsEditor = sharedPreferences.edit();
        if (enabled != null) {
            prefsEditor.putBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED, enabled.booleanValue());
        } else {
            prefsEditor.remove(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED);
        }
        prefsEditor.commit();
    }
}

