/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.NativeSessionFileProvider;
import com.google.firebase.crashlytics.internal.model.StaticSessionData;
import com.google.firebase.inject.Deferred;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

public final class CrashlyticsNativeComponentDeferredProxy
implements CrashlyticsNativeComponent {
    private static final NativeSessionFileProvider MISSING_NATIVE_SESSION_FILE_PROVIDER = new MissingNativeSessionFileProvider();
    private final Deferred<CrashlyticsNativeComponent> deferredNativeComponent;
    private final AtomicReference<CrashlyticsNativeComponent> availableNativeComponent = new AtomicReference<Object>(null);

    public CrashlyticsNativeComponentDeferredProxy(Deferred<CrashlyticsNativeComponent> deferredNativeComponent) {
        this.deferredNativeComponent = deferredNativeComponent;
        this.deferredNativeComponent.whenAvailable(nativeComponent -> {
            Logger.getLogger().d("Crashlytics native component now available.");
            this.availableNativeComponent.set((CrashlyticsNativeComponent)nativeComponent.get());
        });
    }

    @Override
    public boolean hasCrashDataForCurrentSession() {
        CrashlyticsNativeComponent component = this.availableNativeComponent.get();
        return component != null && component.hasCrashDataForCurrentSession();
    }

    @Override
    public boolean hasCrashDataForSession(@NonNull String sessionId) {
        CrashlyticsNativeComponent component = this.availableNativeComponent.get();
        return component != null && component.hasCrashDataForSession(sessionId);
    }

    @Override
    public void prepareNativeSession(@NonNull String sessionId, @NonNull String generator, long startedAtSeconds, @NonNull StaticSessionData sessionData) {
        Logger.getLogger().v("Deferring native open session: " + sessionId);
        this.deferredNativeComponent.whenAvailable(nativeComponent -> ((CrashlyticsNativeComponent)nativeComponent.get()).prepareNativeSession(sessionId, generator, startedAtSeconds, sessionData));
    }

    @Override
    public void finalizeSession(@NonNull String sessionId) {
        this.deferredNativeComponent.whenAvailable(nativeComponent -> ((CrashlyticsNativeComponent)nativeComponent.get()).finalizeSession(sessionId));
    }

    @Override
    @NonNull
    public NativeSessionFileProvider getSessionFileProvider(@NonNull String sessionId) {
        CrashlyticsNativeComponent component = this.availableNativeComponent.get();
        return component == null ? MISSING_NATIVE_SESSION_FILE_PROVIDER : component.getSessionFileProvider(sessionId);
    }

    private static final class MissingNativeSessionFileProvider
    implements NativeSessionFileProvider {
        private MissingNativeSessionFileProvider() {
        }

        @Override
        public File getMinidumpFile() {
            return null;
        }

        @Override
        public File getBinaryImagesFile() {
            return null;
        }

        @Override
        public File getMetadataFile() {
            return null;
        }

        @Override
        public File getSessionFile() {
            return null;
        }

        @Override
        public File getAppFile() {
            return null;
        }

        @Override
        public File getDeviceFile() {
            return null;
        }

        @Override
        public File getOsFile() {
            return null;
        }
    }
}

