/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;

public class DevelopmentPlatformProvider {
    public static final String UNITY_PLATFORM = "Unity";
    private static final String UNITY_VERSION_FIELD = "com.google.firebase.crashlytics.unity_version";
    @Nullable
    private final String developmentPlatform;
    @Nullable
    private final String developmentPlatformVersion;

    public DevelopmentPlatformProvider(Context context) {
        int unityEditorId = CommonUtils.getResourcesIdentifier(context, UNITY_VERSION_FIELD, "string");
        if (unityEditorId != 0) {
            this.developmentPlatform = UNITY_PLATFORM;
            this.developmentPlatformVersion = context.getResources().getString(unityEditorId);
            Logger.getLogger().v("Unity Editor version is: " + this.developmentPlatformVersion);
            return;
        }
        this.developmentPlatform = null;
        this.developmentPlatformVersion = null;
    }

    @Nullable
    public String getDevelopmentPlatform() {
        return this.developmentPlatform;
    }

    @Nullable
    public String getDevelopmentPlatformVersion() {
        return this.developmentPlatformVersion;
    }
}

