/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.DevelopmentPlatformProvider;
import com.google.firebase.crashlytics.internal.common.IdManager;

public class AppData {
    public final String googleAppId;
    public final String buildId;
    public final String installerPackageName;
    public final String packageName;
    public final String versionCode;
    public final String versionName;
    @Nullable
    public final String developmentPlatform;
    @Nullable
    public final String developmentPlatformVersion;

    public static AppData create(Context context, IdManager idManager, String googleAppId, String buildId, DevelopmentPlatformProvider developmentPlatformProvider) throws PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        String installerPackageName = idManager.getInstallerPackageName();
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
        String versionCode = Integer.toString(packageInfo.versionCode);
        String versionName = packageInfo.versionName == null ? "0.0" : packageInfo.versionName;
        return new AppData(googleAppId, buildId, installerPackageName, packageName, versionCode, versionName, developmentPlatformProvider.getDevelopmentPlatform(), developmentPlatformProvider.getDevelopmentPlatformVersion());
    }

    public AppData(String googleAppId, String buildId, String installerPackageName, String packageName, String versionCode, String versionName, @Nullable String developmentPlatform, @Nullable String developmentPlatformVersion) {
        this.googleAppId = googleAppId;
        this.buildId = buildId;
        this.installerPackageName = installerPackageName;
        this.packageName = packageName;
        this.versionCode = versionCode;
        this.versionName = versionName;
        this.developmentPlatform = developmentPlatform;
        this.developmentPlatformVersion = developmentPlatformVersion;
    }
}

