/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import java.io.IOException;

public class DevelopmentPlatformProvider {
    private static final String UNITY_PLATFORM = "Unity";
    private static final String FLUTTER_PLATFORM = "Flutter";
    private static final String UNITY_VERSION_FIELD = "com.google.firebase.crashlytics.unity_version";
    private static final String FLUTTER_ASSETS_PATH = "flutter_assets";
    private final Context context;
    @Nullable
    private DevelopmentPlatform developmentPlatform;

    public DevelopmentPlatformProvider(Context context) {
        this.context = context;
        this.developmentPlatform = null;
    }

    @Nullable
    public String getDevelopmentPlatform() {
        return this.initDevelopmentPlatform().developmentPlatform;
    }

    @Nullable
    public String getDevelopmentPlatformVersion() {
        return this.initDevelopmentPlatform().developmentPlatformVersion;
    }

    public static boolean isUnity(Context context) {
        return CommonUtils.getResourcesIdentifier(context, UNITY_VERSION_FIELD, "string") != 0;
    }

    private boolean assetPathExists(String path) {
        try {
            if (this.context.getAssets() == null) {
                return false;
            }
            String[] list = this.context.getAssets().list(path);
            return list != null && list.length > 0;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private DevelopmentPlatform initDevelopmentPlatform() {
        if (this.developmentPlatform == null) {
            this.developmentPlatform = new DevelopmentPlatform();
        }
        return this.developmentPlatform;
    }

    private class DevelopmentPlatform {
        @Nullable
        private final String developmentPlatform;
        @Nullable
        private final String developmentPlatformVersion;

        private DevelopmentPlatform() {
            int unityEditorId = CommonUtils.getResourcesIdentifier(DevelopmentPlatformProvider.this.context, DevelopmentPlatformProvider.UNITY_VERSION_FIELD, "string");
            if (unityEditorId != 0) {
                this.developmentPlatform = DevelopmentPlatformProvider.UNITY_PLATFORM;
                this.developmentPlatformVersion = DevelopmentPlatformProvider.this.context.getResources().getString(unityEditorId);
                Logger.getLogger().v("Unity Editor version is: " + this.developmentPlatformVersion);
                return;
            }
            if (DevelopmentPlatformProvider.this.assetPathExists(DevelopmentPlatformProvider.FLUTTER_ASSETS_PATH)) {
                this.developmentPlatform = DevelopmentPlatformProvider.FLUTTER_PLATFORM;
                this.developmentPlatformVersion = null;
                Logger.getLogger().v("Development platform is: Flutter");
                return;
            }
            this.developmentPlatform = null;
            this.developmentPlatformVersion = null;
        }
    }
}

