/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import java.util.Locale;

class CrashlyticsAnalyticsListener
implements AnalyticsConnector.AnalyticsConnectorListener {
    static final String EVENT_ORIGIN_KEY = "_o";
    static final String EVENT_NAME_KEY = "name";
    static final String EVENT_PARAMS_KEY = "params";
    static final String CRASHLYTICS_ORIGIN = "clx";
    private AnalyticsEventReceiver crashlyticsOriginEventReceiver;
    private AnalyticsEventReceiver breadcrumbEventReceiver;

    CrashlyticsAnalyticsListener() {
    }

    public void setCrashlyticsOriginEventReceiver(@Nullable AnalyticsEventReceiver receiver) {
        this.crashlyticsOriginEventReceiver = receiver;
    }

    public void setBreadcrumbEventReceiver(@Nullable AnalyticsEventReceiver receiver) {
        this.breadcrumbEventReceiver = receiver;
    }

    public void onMessageTriggered(int id, @Nullable Bundle extras) {
        Logger.getLogger().v(String.format(Locale.US, "Analytics listener received message. ID: %d, Extras: %s", id, extras));
        if (extras == null) {
            return;
        }
        String name = extras.getString(EVENT_NAME_KEY);
        if (name != null) {
            Bundle params = extras.getBundle(EVENT_PARAMS_KEY);
            if (params == null) {
                params = new Bundle();
            }
            this.notifyEventReceivers(name, params);
        }
    }

    private void notifyEventReceivers(@NonNull String name, @NonNull Bundle params) {
        String origin = params.getString(EVENT_ORIGIN_KEY);
        AnalyticsEventReceiver receiver = CRASHLYTICS_ORIGIN.equals(origin) ? this.crashlyticsOriginEventReceiver : this.breadcrumbEventReceiver;
        CrashlyticsAnalyticsListener.notifyEventReceiver(receiver, name, params);
    }

    private static void notifyEventReceiver(@Nullable AnalyticsEventReceiver receiver, @NonNull String name, @NonNull Bundle params) {
        if (receiver == null) {
            return;
        }
        receiver.onEvent(name, params);
    }
}

