/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.settings.Settings;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonTransform;
import org.json.JSONException;
import org.json.JSONObject;

class SettingsV3JsonTransform
implements SettingsJsonTransform {
    SettingsV3JsonTransform() {
    }

    @Override
    public Settings buildFromJson(CurrentTimeProvider currentTimeProvider, JSONObject json) throws JSONException {
        int settingsVersion = json.optInt("settings_version", 0);
        int cacheDuration = json.optInt("cache_duration", 3600);
        double onDemandUploadRatePerMinute = json.optDouble("on_demand_upload_rate_per_minute", 10.0);
        double onDemandBackoffBase = json.optDouble("on_demand_backoff_base", 1.2);
        int onDemandBackoffStepDurationSeconds = json.optInt("on_demand_backoff_step_duration_seconds", 60);
        Settings.SessionData sessionData = json.has("session") ? SettingsV3JsonTransform.buildSessionDataFrom(json.getJSONObject("session")) : SettingsV3JsonTransform.buildSessionDataFrom(new JSONObject());
        Settings.FeatureFlagData featureFlagData = SettingsV3JsonTransform.buildFeatureFlagDataFrom(json.getJSONObject("features"));
        long expiresAtMillis = SettingsV3JsonTransform.getExpiresAtFrom(currentTimeProvider, cacheDuration, json);
        return new Settings(expiresAtMillis, sessionData, featureFlagData, settingsVersion, cacheDuration, onDemandUploadRatePerMinute, onDemandBackoffBase, onDemandBackoffStepDurationSeconds);
    }

    private static Settings.FeatureFlagData buildFeatureFlagDataFrom(JSONObject json) {
        boolean collectReports = json.optBoolean("collect_reports", true);
        boolean collectAnrs = json.optBoolean("collect_anrs", false);
        boolean collectBuildIds = json.optBoolean("collect_build_ids", false);
        return new Settings.FeatureFlagData(collectReports, collectAnrs, collectBuildIds);
    }

    private static Settings.SessionData buildSessionDataFrom(JSONObject json) {
        int maxCustomExceptionEvents = json.optInt("max_custom_exception_events", 8);
        int maxCompleteSessionsCount = 4;
        return new Settings.SessionData(maxCustomExceptionEvents, 4);
    }

    private static long getExpiresAtFrom(CurrentTimeProvider currentTimeProvider, long cacheDurationSeconds, JSONObject json) {
        long expiresAtMillis = json.has("expires_at") ? json.optLong("expires_at") : currentTimeProvider.getCurrentTimeMillis() + cacheDurationSeconds * 1000L;
        return expiresAtMillis;
    }
}

