/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.internal.metadata.KeysMap;
import com.google.firebase.crashlytics.internal.metadata.MetaDataStore;
import com.google.firebase.crashlytics.internal.metadata.RolloutAssignment;
import com.google.firebase.crashlytics.internal.metadata.RolloutAssignmentList;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;

public class UserMetadata {
    public static final String USERDATA_FILENAME = "user-data";
    public static final String KEYDATA_FILENAME = "keys";
    public static final String INTERNAL_KEYDATA_FILENAME = "internal-keys";
    public static final String ROLLOUTS_STATE_FILENAME = "rollouts-state";
    @VisibleForTesting
    public static final int MAX_ATTRIBUTES = 64;
    @VisibleForTesting
    public static final int MAX_ATTRIBUTE_SIZE = 1024;
    @VisibleForTesting
    public static final int MAX_INTERNAL_KEY_SIZE = 8192;
    @VisibleForTesting
    public static final int MAX_ROLLOUT_ASSIGNMENTS = 128;
    private final MetaDataStore metaDataStore;
    private final CrashlyticsBackgroundWorker backgroundWorker;
    private String sessionIdentifier;
    private final SerializeableKeysMap customKeys = new SerializeableKeysMap(false);
    private final SerializeableKeysMap internalKeys = new SerializeableKeysMap(true);
    private final RolloutAssignmentList rolloutsState = new RolloutAssignmentList(128);
    private final AtomicMarkableReference<String> userId = new AtomicMarkableReference<Object>(null, false);

    @Nullable
    public static String readUserId(String sessionId, FileStore fileStore) {
        return new MetaDataStore(fileStore).readUserId(sessionId);
    }

    public static UserMetadata loadFromExistingSession(String sessionId, FileStore fileStore, CrashlyticsBackgroundWorker backgroundWorker) {
        MetaDataStore store = new MetaDataStore(fileStore);
        UserMetadata metadata = new UserMetadata(sessionId, fileStore, backgroundWorker);
        metadata.customKeys.map.getReference().setKeys(store.readKeyData(sessionId, false));
        metadata.internalKeys.map.getReference().setKeys(store.readKeyData(sessionId, true));
        metadata.userId.set(store.readUserId(sessionId), false);
        metadata.rolloutsState.updateRolloutAssignmentList(store.readRolloutsState(sessionId));
        return metadata;
    }

    public UserMetadata(String sessionIdentifier, FileStore fileStore, CrashlyticsBackgroundWorker backgroundWorker) {
        this.sessionIdentifier = sessionIdentifier;
        this.metaDataStore = new MetaDataStore(fileStore);
        this.backgroundWorker = backgroundWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewSession(String sessionId) {
        String string = this.sessionIdentifier;
        synchronized (string) {
            this.sessionIdentifier = sessionId;
            Map<String, String> keyData = this.customKeys.getKeys();
            List<RolloutAssignment> rolloutAssignments = this.rolloutsState.getRolloutAssignmentList();
            if (this.getUserId() != null) {
                this.metaDataStore.writeUserData(sessionId, this.getUserId());
            }
            if (!keyData.isEmpty()) {
                this.metaDataStore.writeKeyData(sessionId, keyData);
            }
            if (!rolloutAssignments.isEmpty()) {
                this.metaDataStore.writeRolloutState(sessionId, rolloutAssignments);
            }
        }
    }

    @Nullable
    public String getUserId() {
        return this.userId.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserId(String identifier) {
        String sanitizedNewId = KeysMap.sanitizeString(identifier, 1024);
        AtomicMarkableReference<String> atomicMarkableReference = this.userId;
        synchronized (atomicMarkableReference) {
            String currentId = this.userId.getReference();
            if (CommonUtils.nullSafeEquals(sanitizedNewId, currentId)) {
                return;
            }
            this.userId.set(sanitizedNewId, true);
        }
        this.backgroundWorker.submit(() -> {
            this.serializeUserDataIfNeeded();
            return null;
        });
    }

    public Map<String, String> getCustomKeys() {
        return this.customKeys.getKeys();
    }

    public boolean setCustomKey(String key, String value) {
        return this.customKeys.setKey(key, value);
    }

    public void setCustomKeys(Map<String, String> keysAndValues) {
        this.customKeys.setKeys(keysAndValues);
    }

    public Map<String, String> getInternalKeys() {
        return this.internalKeys.getKeys();
    }

    public boolean setInternalKey(String key, String value) {
        return this.internalKeys.setKey(key, value);
    }

    public List<CrashlyticsReport.Session.Event.RolloutAssignment> getRolloutsState() {
        return this.rolloutsState.getReportRolloutsState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRolloutsState(List<RolloutAssignment> rolloutAssignments) {
        RolloutAssignmentList rolloutAssignmentList = this.rolloutsState;
        synchronized (rolloutAssignmentList) {
            if (!this.rolloutsState.updateRolloutAssignmentList(rolloutAssignments)) {
                return false;
            }
            List<RolloutAssignment> updatedRolloutAssignments = this.rolloutsState.getRolloutAssignmentList();
            this.backgroundWorker.submit(() -> {
                this.metaDataStore.writeRolloutState(this.sessionIdentifier, updatedRolloutAssignments);
                return null;
            });
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeUserDataIfNeeded() {
        String userIdString = null;
        boolean needsUpdate = false;
        AtomicMarkableReference<String> atomicMarkableReference = this.userId;
        synchronized (atomicMarkableReference) {
            if (this.userId.isMarked()) {
                userIdString = this.getUserId();
                needsUpdate = true;
                this.userId.set(userIdString, false);
            }
        }
        if (needsUpdate) {
            this.metaDataStore.writeUserData(this.sessionIdentifier, userIdString);
        }
    }

    private class SerializeableKeysMap {
        final AtomicMarkableReference<KeysMap> map;
        private final AtomicReference<Callable<Void>> queuedSerializer = new AtomicReference<Object>(null);
        private final boolean isInternal;

        public SerializeableKeysMap(boolean isInternal) {
            this.isInternal = isInternal;
            KeysMap keysMap = new KeysMap(64, isInternal ? 8192 : 1024);
            this.map = new AtomicMarkableReference<KeysMap>(keysMap, false);
        }

        public Map<String, String> getKeys() {
            return this.map.getReference().getKeys();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setKey(String key, String value) {
            SerializeableKeysMap serializeableKeysMap = this;
            synchronized (serializeableKeysMap) {
                if (!this.map.getReference().setKey(key, value)) {
                    return false;
                }
                this.map.set(this.map.getReference(), true);
            }
            this.scheduleSerializationTaskIfNeeded();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setKeys(Map<String, String> keysAndValues) {
            SerializeableKeysMap serializeableKeysMap = this;
            synchronized (serializeableKeysMap) {
                this.map.getReference().setKeys(keysAndValues);
                this.map.set(this.map.getReference(), true);
            }
            this.scheduleSerializationTaskIfNeeded();
        }

        private void scheduleSerializationTaskIfNeeded() {
            Callable<Void> newCallable = () -> {
                this.queuedSerializer.set(null);
                this.serializeIfMarked();
                return null;
            };
            if (this.queuedSerializer.compareAndSet(null, newCallable)) {
                UserMetadata.this.backgroundWorker.submit(newCallable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serializeIfMarked() {
            Map<String, String> keyData = null;
            SerializeableKeysMap serializeableKeysMap = this;
            synchronized (serializeableKeysMap) {
                if (this.map.isMarked()) {
                    keyData = this.map.getReference().getKeys();
                    this.map.set(this.map.getReference(), false);
                }
            }
            if (keyData != null) {
                UserMetadata.this.metaDataStore.writeKeyData(UserMetadata.this.sessionIdentifier, keyData, this.isInternal);
            }
        }
    }
}

