/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;

public class CustomKeysAndValues {
    final Map<String, String> keysAndValues;

    CustomKeysAndValues(@NonNull Builder builder) {
        this.keysAndValues = builder.keysAndValues;
    }

    public static class Builder {
        private Map<String, String> keysAndValues = new HashMap<String, String>();

        @NonNull
        public Builder putString(@NonNull String key, @NonNull String value) {
            this.keysAndValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putBoolean(@NonNull String key, boolean value) {
            this.keysAndValues.put(key, Boolean.toString(value));
            return this;
        }

        @NonNull
        public Builder putDouble(@NonNull String key, double value) {
            this.keysAndValues.put(key, Double.toString(value));
            return this;
        }

        @NonNull
        public Builder putFloat(@NonNull String key, float value) {
            this.keysAndValues.put(key, Float.toString(value));
            return this;
        }

        @NonNull
        public Builder putLong(@NonNull String key, long value) {
            this.keysAndValues.put(key, Long.toString(value));
            return this;
        }

        @NonNull
        public Builder putInt(@NonNull String key, int value) {
            this.keysAndValues.put(key, Integer.toString(value));
            return this;
        }

        @NonNull
        public CustomKeysAndValues build() {
            return new CustomKeysAndValues(this);
        }
    }
}

