/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class CrashlyticsWorker {
    private final ExecutorService executor;
    private final Object tailLock = new Object();
    private Task<?> tail = Tasks.forResult(null);

    public CrashlyticsWorker(ExecutorService executor) {
        this.executor = executor;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> submit(Callable<T> callable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            if (this.tail.isCanceled()) {
                this.tail = this.tail.continueWithTask((Executor)this.executor, task -> Tasks.forResult(null));
            }
            this.tail = result = this.tail.continueWith((Executor)this.executor, task -> callable.call());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> submit(Runnable runnable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            if (this.tail.isCanceled()) {
                this.tail = this.tail.continueWithTask((Executor)this.executor, task -> Tasks.forResult(null));
            }
            this.tail = result = this.tail.continueWith((Executor)this.executor, task -> {
                runnable.run();
                return null;
            });
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> submitTask(Callable<Task<T>> callable) {
        Object object = this.tailLock;
        synchronized (object) {
            Task result;
            this.tail = result = this.tail.continueWithTask((Executor)this.executor, task -> (Task)callable.call());
            return result;
        }
    }

    @VisibleForTesting
    public void await() throws ExecutionException, InterruptedException {
        Tasks.await(this.submit(() -> {}));
    }
}

