/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.FirebaseInstallationId;
import com.google.firebase.crashlytics.internal.common.InstallIdProvider;
import com.google.firebase.crashlytics.internal.common.InstallerPackageNameProvider;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.InstallationTokenResult;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class IdManager
implements InstallIdProvider {
    private static final int TIMEOUT_MILLIS = 10000;
    public static final String DEFAULT_VERSION_NAME = "0.0";
    static final String PREFKEY_ADVERTISING_ID = "crashlytics.advertising.id";
    static final String PREFKEY_INSTALLATION_UUID = "crashlytics.installation.id";
    static final String PREFKEY_FIREBASE_IID = "firebase.installation.id";
    static final String PREFKEY_LEGACY_INSTALLATION_UUID = "crashlytics.installation.id";
    private static final Pattern ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
    private static final String SYNTHETIC_FID_PREFIX = "SYN_";
    private static final String FORWARD_SLASH_REGEX = Pattern.quote("/");
    private final InstallerPackageNameProvider installerPackageNameProvider;
    private final Context appContext;
    private final String appIdentifier;
    private final FirebaseInstallationsApi firebaseInstallations;
    private final DataCollectionArbiter dataCollectionArbiter;
    private InstallIdProvider.InstallIds installIds;

    public IdManager(Context appContext, String appIdentifier, FirebaseInstallationsApi firebaseInstallations, DataCollectionArbiter dataCollectionArbiter) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext must not be null");
        }
        if (appIdentifier == null) {
            throw new IllegalArgumentException("appIdentifier must not be null");
        }
        this.appContext = appContext;
        this.appIdentifier = appIdentifier;
        this.firebaseInstallations = firebaseInstallations;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.installerPackageNameProvider = new InstallerPackageNameProvider();
    }

    @NonNull
    private static String formatId(@NonNull String id) {
        return ID_PATTERN.matcher(id).replaceAll("").toLowerCase(Locale.US);
    }

    @Override
    @NonNull
    public synchronized InstallIdProvider.InstallIds getInstallIds() {
        if (!this.shouldRefresh()) {
            return this.installIds;
        }
        Logger.getLogger().v("Determining Crashlytics installation ID...");
        SharedPreferences prefs = CommonUtils.getSharedPrefs(this.appContext);
        String cachedFid = prefs.getString(PREFKEY_FIREBASE_IID, null);
        Logger.getLogger().v("Cached Firebase Installation ID: " + cachedFid);
        if (this.dataCollectionArbiter.isAutomaticDataCollectionEnabled()) {
            FirebaseInstallationId trueFid = this.fetchTrueFid(false);
            Logger.getLogger().v("Fetched Firebase Installation ID: " + trueFid.getFid());
            if (trueFid.getFid() == null) {
                trueFid = new FirebaseInstallationId(cachedFid == null ? IdManager.createSyntheticFid() : cachedFid, null);
            }
            this.installIds = Objects.equals(trueFid.getFid(), cachedFid) ? InstallIdProvider.InstallIds.create(this.readCachedCrashlyticsInstallId(prefs), trueFid) : InstallIdProvider.InstallIds.create(this.createAndCacheCrashlyticsInstallId(trueFid.getFid(), prefs), trueFid);
        } else {
            this.installIds = IdManager.isSyntheticFid(cachedFid) ? InstallIdProvider.InstallIds.createWithoutFid(this.readCachedCrashlyticsInstallId(prefs)) : InstallIdProvider.InstallIds.createWithoutFid(this.createAndCacheCrashlyticsInstallId(IdManager.createSyntheticFid(), prefs));
        }
        Logger.getLogger().v("Install IDs: " + this.installIds);
        return this.installIds;
    }

    private boolean shouldRefresh() {
        return this.installIds == null || this.installIds.getFirebaseInstallationId() == null && this.dataCollectionArbiter.isAutomaticDataCollectionEnabled();
    }

    static String createSyntheticFid() {
        return SYNTHETIC_FID_PREFIX + UUID.randomUUID().toString();
    }

    static boolean isSyntheticFid(String fid) {
        return fid != null && fid.startsWith(SYNTHETIC_FID_PREFIX);
    }

    private String readCachedCrashlyticsInstallId(SharedPreferences prefs) {
        return prefs.getString("crashlytics.installation.id", null);
    }

    @NonNull
    public FirebaseInstallationId fetchTrueFid(boolean validate) {
        CrashlyticsWorkers.checkNotMainThread();
        String fid = null;
        String authToken = null;
        if (validate) {
            try {
                authToken = ((InstallationTokenResult)Tasks.await((Task)this.firebaseInstallations.getToken(false), (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS)).getToken();
            }
            catch (Exception ex) {
                Logger.getLogger().w("Error getting Firebase authentication token.", ex);
            }
        }
        try {
            fid = (String)Tasks.await((Task)this.firebaseInstallations.getId(), (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            Logger.getLogger().w("Error getting Firebase installation id.", ex);
        }
        return new FirebaseInstallationId(fid, authToken);
    }

    @NonNull
    private synchronized String createAndCacheCrashlyticsInstallId(String fidToCache, SharedPreferences prefs) {
        String iid = IdManager.formatId(UUID.randomUUID().toString());
        Logger.getLogger().v("Created new Crashlytics installation ID: " + iid + " for FID: " + fidToCache);
        prefs.edit().putString("crashlytics.installation.id", iid).putString(PREFKEY_FIREBASE_IID, fidToCache).apply();
        return iid;
    }

    public String getAppIdentifier() {
        return this.appIdentifier;
    }

    public String getOsDisplayVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.RELEASE);
    }

    public String getOsBuildVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.INCREMENTAL);
    }

    public String getModelName() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.MANUFACTURER), this.removeForwardSlashesIn(Build.MODEL));
    }

    private String removeForwardSlashesIn(String s) {
        return s.replaceAll(FORWARD_SLASH_REGEX, "");
    }

    public String getInstallerPackageName() {
        return this.installerPackageNameProvider.getInstallerPackageName(this.appContext);
    }
}

