/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers;
import com.google.firebase.inject.Deferred;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.remoteconfig.interop.FirebaseRemoteConfigInterop;
import com.google.firebase.sessions.api.FirebaseSessionsDependencies;
import com.google.firebase.sessions.api.SessionSubscriber;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class CrashlyticsRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-cls";
    private final Qualified<ExecutorService> backgroundExecutorService = Qualified.qualified(Background.class, ExecutorService.class);
    private final Qualified<ExecutorService> blockingExecutorService = Qualified.qualified(Blocking.class, ExecutorService.class);
    private final Qualified<ExecutorService> lightweightExecutorService = Qualified.qualified(Lightweight.class, ExecutorService.class);

    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseCrashlytics.class).name(LIBRARY_NAME).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(FirebaseInstallationsApi.class)).add(Dependency.required(this.backgroundExecutorService)).add(Dependency.required(this.blockingExecutorService)).add(Dependency.required(this.lightweightExecutorService)).add(Dependency.deferred(CrashlyticsNativeComponent.class)).add(Dependency.deferred(AnalyticsConnector.class)).add(Dependency.deferred(FirebaseRemoteConfigInterop.class)).factory(this::buildCrashlytics).eagerInDefaultApp().build(), LibraryVersionComponent.create((String)LIBRARY_NAME, (String)"19.4.1"));
    }

    private FirebaseCrashlytics buildCrashlytics(ComponentContainer container) {
        CrashlyticsWorkers.setEnforcement(false);
        long startTime = System.currentTimeMillis();
        FirebaseCrashlytics crashlytics = FirebaseCrashlytics.init((FirebaseApp)container.get(FirebaseApp.class), (FirebaseInstallationsApi)container.get(FirebaseInstallationsApi.class), (Deferred<CrashlyticsNativeComponent>)container.getDeferred(CrashlyticsNativeComponent.class), (Deferred<AnalyticsConnector>)container.getDeferred(AnalyticsConnector.class), (Deferred<FirebaseRemoteConfigInterop>)container.getDeferred(FirebaseRemoteConfigInterop.class), (ExecutorService)container.get(this.backgroundExecutorService), (ExecutorService)container.get(this.blockingExecutorService), (ExecutorService)container.get(this.lightweightExecutorService));
        long duration = System.currentTimeMillis() - startTime;
        if (duration > 16L) {
            Logger.getLogger().d("Initializing Crashlytics blocked main for " + duration + " ms");
        }
        return crashlytics;
    }

    static {
        FirebaseSessionsDependencies.addDependency((SessionSubscriber.Name)SessionSubscriber.Name.CRASHLYTICS);
    }
}

