/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.concurrency;

import com.google.android.gms.tasks.CancellationTokenSource;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CrashlyticsTasks {
    private static final Executor DIRECT = Runnable::run;

    public static <T> Task<T> race(Task<T> task1, Task<T> task2) {
        CancellationTokenSource cancellation = new CancellationTokenSource();
        TaskCompletionSource result = new TaskCompletionSource(cancellation.getToken());
        AtomicBoolean otherTaskCancelled = new AtomicBoolean(false);
        Continuation continuation = task -> {
            if (task.isSuccessful()) {
                result.trySetResult(task.getResult());
            } else if (task.getException() != null) {
                result.trySetException(task.getException());
            } else if (otherTaskCancelled.getAndSet(true)) {
                cancellation.cancel();
            }
            return Tasks.forResult(null);
        };
        task1.continueWithTask(DIRECT, continuation);
        task2.continueWithTask(DIRECT, continuation);
        return result.getTask();
    }

    private CrashlyticsTasks() {
    }
}

