/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.concurrency;

import android.os.Build;
import android.os.Looper;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorker;
import com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/firebase/crashlytics/internal/concurrency/CrashlyticsWorkers;", "", "backgroundExecutorService", "Ljava/util/concurrent/ExecutorService;", "blockingExecutorService", "(Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;)V", "common", "Lcom/google/firebase/crashlytics/internal/concurrency/CrashlyticsWorker;", "dataCollect", "diskWrite", "network", "Companion", "com.google.firebase-firebase-crashlytics"})
public final class CrashlyticsWorkers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final CrashlyticsWorker common;
    @JvmField
    @NotNull
    public final CrashlyticsWorker diskWrite;
    @JvmField
    @NotNull
    public final CrashlyticsWorker dataCollect;
    @JvmField
    @NotNull
    public final CrashlyticsWorker network;
    private static boolean enforcement;

    public CrashlyticsWorkers(@NotNull ExecutorService backgroundExecutorService, @NotNull ExecutorService blockingExecutorService) {
        Intrinsics.checkNotNullParameter((Object)backgroundExecutorService, (String)"backgroundExecutorService");
        Intrinsics.checkNotNullParameter((Object)blockingExecutorService, (String)"blockingExecutorService");
        this.common = new CrashlyticsWorker(backgroundExecutorService);
        this.diskWrite = new CrashlyticsWorker(backgroundExecutorService);
        this.dataCollect = new CrashlyticsWorker(backgroundExecutorService);
        this.network = new CrashlyticsWorker(blockingExecutorService);
    }

    public static final boolean getEnforcement() {
        return Companion.getEnforcement();
    }

    public static final void setEnforcement(boolean bl) {
        Companion.setEnforcement(bl);
    }

    @JvmStatic
    public static final void checkNotMainThread() {
        Companion.checkNotMainThread();
    }

    @JvmStatic
    public static final void checkBlockingThread() {
        Companion.checkBlockingThread();
    }

    @JvmStatic
    public static final void checkBackgroundThread() {
        Companion.checkBackgroundThread();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0010H\u0007J\b\u0010\u0012\u001a\u00020\u0010H\u0007J$\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/google/firebase/crashlytics/internal/concurrency/CrashlyticsWorkers$Companion;", "", "()V", "enforcement", "", "getEnforcement$annotations", "getEnforcement", "()Z", "setEnforcement", "(Z)V", "threadName", "", "kotlin.jvm.PlatformType", "getThreadName", "()Ljava/lang/String;", "checkBackgroundThread", "", "checkBlockingThread", "checkNotMainThread", "checkThread", "isCorrectThread", "Lkotlin/Function0;", "failureMessage", "isBackgroundThread", "isBlockingThread", "isNotMainThread", "com.google.firebase-firebase-crashlytics"})
    public static final class Companion {
        private Companion() {
        }

        private final String getThreadName() {
            return Thread.currentThread().getName();
        }

        public final boolean getEnforcement() {
            return enforcement;
        }

        public final void setEnforcement(boolean bl) {
            enforcement = bl;
        }

        @JvmStatic
        public static /* synthetic */ void getEnforcement$annotations() {
        }

        @JvmStatic
        public final void checkNotMainThread() {
            this.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                @NotNull
                public final Boolean invoke() {
                    return com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers$Companion.access$isNotMainThread((Companion)this.receiver);
                }
            }), (Function0<String>)((Function0)checkNotMainThread.2.INSTANCE));
        }

        @JvmStatic
        public final void checkBlockingThread() {
            this.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                @NotNull
                public final Boolean invoke() {
                    return com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers$Companion.access$isBlockingThread((Companion)this.receiver);
                }
            }), (Function0<String>)((Function0)checkBlockingThread.2.INSTANCE));
        }

        @JvmStatic
        public final void checkBackgroundThread() {
            this.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                @NotNull
                public final Boolean invoke() {
                    return com.google.firebase.crashlytics.internal.concurrency.CrashlyticsWorkers$Companion.access$isBackgroundThread((Companion)this.receiver);
                }
            }), (Function0<String>)((Function0)checkBackgroundThread.2.INSTANCE));
        }

        private final boolean isNotMainThread() {
            return Build.VERSION.SDK_INT >= 23 ? !Looper.getMainLooper().isCurrentThread() : !Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper());
        }

        private final boolean isBlockingThread() {
            String string = this.getThreadName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"Firebase Blocking Thread #", (boolean)false, (int)2, null);
        }

        private final boolean isBackgroundThread() {
            String string = this.getThreadName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"Firebase Background Thread #", (boolean)false, (int)2, null);
        }

        private final void checkThread(Function0<Boolean> isCorrectThread, Function0<String> failureMessage) {
            if (!((Boolean)isCorrectThread.invoke()).booleanValue()) {
                boolean bl;
                Logger.getLogger().d((String)failureMessage.invoke());
                boolean bl2 = bl = !this.getEnforcement();
                if (_Assertions.ENABLED && !bl) {
                    Object object = failureMessage.invoke();
                    throw new AssertionError(object);
                }
            }
        }

        public static final /* synthetic */ boolean access$isNotMainThread(Companion $this) {
            return $this.isNotMainThread();
        }

        public static final /* synthetic */ String access$getThreadName(Companion $this) {
            return $this.getThreadName();
        }

        public static final /* synthetic */ boolean access$isBlockingThread(Companion $this) {
            return $this.isBlockingThread();
        }

        public static final /* synthetic */ boolean access$isBackgroundThread(Companion $this) {
            return $this.isBackgroundThread();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

