/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/google/firebase/crashlytics/internal/ProcessDetailsProvider;", "", "<init>", "()V", "getAppProcessDetails", "", "Lcom/google/firebase/crashlytics/internal/model/CrashlyticsReport$Session$Event$Application$ProcessDetails;", "context", "Landroid/content/Context;", "getCurrentProcessDetails", "buildProcessDetails", "processName", "", "pid", "", "importance", "isDefaultProcess", "", "getProcessName", "com.google.firebase-firebase-crashlytics"})
@SourceDebugExtension(value={"SMAP\nProcessDetailsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDetailsProvider.kt\ncom/google/firebase/crashlytics/internal/ProcessDetailsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n774#2:95\n865#2,2:96\n1557#2:98\n1628#2,3:99\n1#3:102\n*S KotlinDebug\n*F\n+ 1 ProcessDetailsProvider.kt\ncom/google/firebase/crashlytics/internal/ProcessDetailsProvider\n*L\n43#1:95\n43#1:96,2\n47#1:98\n47#1:99,3\n*E\n"})
public final class ProcessDetailsProvider {
    @NotNull
    public static final ProcessDetailsProvider INSTANCE = new ProcessDetailsProvider();

    private ProcessDetailsProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CrashlyticsReport.Session.Event.Application.ProcessDetails> getAppProcessDetails(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ActivityManager.RunningAppProcessInfo it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int appUid = context.getApplicationInfo().uid;
        String defaultProcessName = context.getApplicationInfo().processName;
        Object object = context.getSystemService("activity");
        ActivityManager activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
        Object object2 = activityManager;
        if (object2 == null || (object2 = object2.getRunningAppProcesses()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object runningAppProcesses = object2;
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)((Iterable)runningAppProcesses));
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ActivityManager.RunningAppProcessInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.uid == appUid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void runningAppProcessInfo;
            it = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CrashlyticsReport.Session.Event.Application.ProcessDetails.builder().setProcessName(runningAppProcessInfo.processName).setPid(runningAppProcessInfo.pid).setImportance(runningAppProcessInfo.importance).setDefaultProcess(Intrinsics.areEqual((Object)runningAppProcessInfo.processName, (Object)defaultProcessName)).build());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final CrashlyticsReport.Session.Event.Application.ProcessDetails getCurrentProcessDetails(@NotNull Context context) {
        CrashlyticsReport.Session.Event.Application.ProcessDetails processDetails;
        Object v0;
        int pid;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            pid = Process.myPid();
            Iterable iterable = this.getAppProcessDetails(context);
            for (Object t : iterable) {
                CrashlyticsReport.Session.Event.Application.ProcessDetails it = (CrashlyticsReport.Session.Event.Application.ProcessDetails)t;
                boolean bl = false;
                if (!(it.getPid() == pid)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((processDetails = (CrashlyticsReport.Session.Event.Application.ProcessDetails)v0) == null) {
            processDetails = ProcessDetailsProvider.buildProcessDetails$default(this, this.getProcessName(), pid, 0, false, 12, null);
        }
        return processDetails;
    }

    @JvmOverloads
    @NotNull
    public final CrashlyticsReport.Session.Event.Application.ProcessDetails buildProcessDetails(@NotNull String processName, int pid, int importance, boolean isDefaultProcess) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        CrashlyticsReport.Session.Event.Application.ProcessDetails processDetails = CrashlyticsReport.Session.Event.Application.ProcessDetails.builder().setProcessName(processName).setPid(pid).setImportance(importance).setDefaultProcess(isDefaultProcess).build();
        Intrinsics.checkNotNullExpressionValue((Object)processDetails, (String)"build(...)");
        return processDetails;
    }

    public static /* synthetic */ CrashlyticsReport.Session.Event.Application.ProcessDetails buildProcessDetails$default(ProcessDetailsProvider processDetailsProvider, String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return processDetailsProvider.buildProcessDetails(string, n, n2, bl);
    }

    private final String getProcessName() {
        String string;
        if (Build.VERSION.SDK_INT > 33) {
            String string2 = Process.myProcessName();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else if (Build.VERSION.SDK_INT >= 28) {
            string = Application.getProcessName();
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    @JvmOverloads
    @NotNull
    public final CrashlyticsReport.Session.Event.Application.ProcessDetails buildProcessDetails(@NotNull String processName, int pid, int importance) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        return ProcessDetailsProvider.buildProcessDetails$default(this, processName, pid, importance, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final CrashlyticsReport.Session.Event.Application.ProcessDetails buildProcessDetails(@NotNull String processName, int pid) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        return ProcessDetailsProvider.buildProcessDetails$default(this, processName, pid, 0, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final CrashlyticsReport.Session.Event.Application.ProcessDetails buildProcessDetails(@NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        return ProcessDetailsProvider.buildProcessDetails$default(this, processName, 0, 0, false, 14, null);
    }
}

