/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbln;
import com.google.android.gms.internal.zzblp;
import com.google.android.gms.internal.zzblx;
import com.google.android.gms.internal.zzbop;
import com.google.android.gms.internal.zzbpo;
import com.google.android.gms.internal.zzbpp;
import com.google.android.gms.internal.zzbpq;
import com.google.android.gms.internal.zzbps;
import com.google.android.gms.internal.zzbpx;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzblv {
    private static long zzcaB = 0L;
    private zzb zzcaC;
    private boolean zzcaD = false;
    private boolean zzcaE = false;
    private long zzcaF = 0L;
    private zzblx zzcaG;
    private zza zzcaH;
    private ScheduledFuture<?> zzcaI;
    private ScheduledFuture<?> zzcaJ;
    private final zzbln zzcaK;
    private final ScheduledExecutorService zzbYl;
    private final zzbop zzbYx;

    public zzblv(zzbln zzbln2, zzblp zzblp2, String string, zza zza2, String string2) {
        this.zzcaK = zzbln2;
        this.zzbYl = zzbln2.zzVJ();
        this.zzcaH = zza2;
        long l = zzcaB++;
        this.zzbYx = new zzbop(zzbln2.zzVH(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.zzcaC = this.zza(zzblp2, string, string2);
    }

    private zzb zza(zzblp zzblp2, String string, String string2) {
        String string3 = string != null ? string : zzblp2.getHost();
        URI uRI = zzblp.zza(string3, zzblp2.isSecure(), zzblp2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.zzcaK.zzjQ());
        zzbpo zzbpo2 = new zzbpo(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzbpo2);
        return zzc2;
    }

    public void open() {
        this.zzcaC.connect();
        this.zzcaJ = this.zzbYl.schedule(new Runnable(){

            @Override
            public void run() {
                zzblv.this.zzWs();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi("websocket is being closed", new Object[0]);
        }
        this.zzcaE = true;
        this.zzcaC.close();
        if (this.zzcaJ != null) {
            this.zzcaJ.cancel(true);
        }
        if (this.zzcaI != null) {
            this.zzcaI.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzWp();
        try {
            int n;
            String string = zzbpx.zzaE(map);
            String[] stringArray = zzblv.zzF(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.zzcaC.zziT(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.zzcaC.zziT(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.zzbYx.zzd(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zziQ(String string) {
        this.zzcaG.zziU(string);
        --this.zzcaF;
        if (this.zzcaF == 0L) {
            try {
                this.zzcaG.zzWz();
                Map<String, Object> map = zzbpx.zzjf(this.zzcaG.toString());
                this.zzcaG = null;
                if (this.zzbYx.zzYT()) {
                    String string2 = String.valueOf(map);
                    this.zzbYx.zzi(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.zzcaH.zzas(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.zzcaG.toString());
                this.zzbYx.zzd(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.zzcaG.toString());
                this.zzbYx.zzd(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzpJ(int n) {
        this.zzcaF = n;
        this.zzcaG = new zzblx();
        if (this.zzbYx.zzYT()) {
            long l = this.zzcaF;
            this.zzbYx.zzi(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zziR(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzpJ(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.zzpJ(1);
        return string;
    }

    private void zziS(String string) {
        if (!this.zzcaE) {
            this.zzWp();
            if (this.isBuffering()) {
                this.zziQ(string);
            } else {
                String string2 = this.zziR(string);
                if (string2 != null) {
                    this.zziQ(string2);
                }
            }
        }
    }

    private void zzWp() {
        if (!this.zzcaE) {
            if (this.zzcaI != null) {
                this.zzcaI.cancel(false);
                if (this.zzbYx.zzYT()) {
                    long l = this.zzcaI.getDelay(TimeUnit.MILLISECONDS);
                    this.zzbYx.zzi(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi("Reset keepAlive", new Object[0]);
            }
            this.zzcaI = this.zzbYl.schedule(this.zzWq(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzWq() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzblv.this.zzcaC != null) {
                    zzblv.this.zzcaC.zziT("0");
                    zzblv.this.zzWp();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.zzcaG != null;
    }

    private void zzWr() {
        if (!this.zzcaE) {
            if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.zzcaC = null;
        if (this.zzcaI != null) {
            this.zzcaI.cancel(false);
        }
    }

    private void shutdown() {
        this.zzcaE = true;
        this.zzcaH.zzaV(this.zzcaD);
    }

    private void zzWs() {
        if (!this.zzcaD && !this.zzcaE) {
            if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi("timed out on connect", new Object[0]);
            }
            this.zzcaC.close();
        }
    }

    private static String[] zzF(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzbpp {
        private zzbpo zzcaM;

        private zzc(zzbpo zzbpo2) {
            this.zzcaM = zzbpo2;
            this.zzcaM.zza(this);
        }

        @Override
        public void zzWt() {
            zzblv.this.zzbYl.execute(new Runnable(){

                @Override
                public void run() {
                    zzblv.this.zzcaJ.cancel(false);
                    zzblv.this.zzcaD = true;
                    if (zzblv.this.zzbYx.zzYT()) {
                        zzblv.this.zzbYx.zzi("websocket opened", new Object[0]);
                    }
                    zzblv.this.zzWp();
                }
            });
        }

        @Override
        public void zza(zzbps zzbps2) {
            final String string = zzbps2.getText();
            if (zzblv.this.zzbYx.zzYT()) {
                String string2 = String.valueOf(string);
                zzblv.this.zzbYx.zzi(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzblv.this.zzbYl.execute(new Runnable(){

                @Override
                public void run() {
                    zzblv.this.zziS(string);
                }
            });
        }

        @Override
        public void onClose() {
            zzblv.this.zzbYl.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzblv.this.zzbYx.zzYT()) {
                        zzblv.this.zzbYx.zzi("closed", new Object[0]);
                    }
                    zzblv.this.zzWr();
                }
            });
        }

        @Override
        public void zza(final zzbpq zzbpq2) {
            zzblv.this.zzbYl.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzbpq2.getCause() != null && zzbpq2.getCause() instanceof EOFException) {
                        zzblv.this.zzbYx.zzi("WebSocket reached EOF.", new Object[0]);
                    } else {
                        zzblv.this.zzbYx.zza("WebSocket error.", zzbpq2, new Object[0]);
                    }
                    zzblv.this.zzWr();
                }
            });
        }

        @Override
        public void zziT(String string) {
            this.zzcaM.zziT(string);
        }

        @Override
        public void close() {
            this.zzcaM.close();
        }

        private void shutdown() {
            this.zzcaM.close();
            try {
                this.zzcaM.zzZL();
            }
            catch (InterruptedException interruptedException) {
                zzblv.this.zzbYx.zzd("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.zzcaM.connect();
            }
            catch (zzbpq zzbpq2) {
                if (zzblv.this.zzbYx.zzYT()) {
                    zzblv.this.zzbYx.zza("Error connecting", zzbpq2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zziT(String var1);
    }

    public static interface zza {
        public void zzas(Map<String, Object> var1);

        public void zzaV(boolean var1);
    }
}

