/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbsl;
import com.google.android.gms.internal.zzbsn;
import com.google.android.gms.internal.zzbso;
import com.google.android.gms.internal.zzbsp;
import com.google.android.gms.internal.zzbsr;
import com.google.android.gms.internal.zzbss;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzbsm {
    private static final AtomicInteger zzcjQ = new AtomicInteger(0);
    private static final Charset zzcjR = Charset.forName("UTF-8");
    private volatile zza zzcjS = zza.zzcke;
    private volatile Socket zzcjT = null;
    private zzbsn zzcjU = null;
    private final URI zzcjV;
    private final zzbsr zzcjW;
    private final zzbss zzcjX;
    private final zzbsp zzcjY;
    private final int zzazO = zzcjQ.incrementAndGet();
    private final Thread zzcjZ = zzbsm.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzbsm.this.zzabw();
        }
    });
    private static ThreadFactory zzcka = Executors.defaultThreadFactory();
    private static zzbsl zzckb = new zzbsl(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return zzcka;
    }

    static zzbsl zzabq() {
        return zzckb;
    }

    public static void zza(ThreadFactory threadFactory, zzbsl zzbsl2) {
        zzcka = threadFactory;
        zzckb = zzbsl2;
    }

    public zzbsm(URI uRI, String string, Map<String, String> map) {
        this.zzcjV = uRI;
        this.zzcjY = new zzbsp(uRI, string, map);
        this.zzcjW = new zzbsr(this);
        this.zzcjX = new zzbss(this, "TubeSock", this.zzazO);
    }

    public void zza(zzbsn zzbsn2) {
        this.zzcjU = zzbsn2;
    }

    zzbsn zzabr() {
        return this.zzcjU;
    }

    public synchronized void connect() {
        if (this.zzcjS != zza.zzcke) {
            this.zzcjU.zza(new zzbso("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzazO;
        zzbsm.zzabq().zza(this.zzabx(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzcjS = zza.zzckf;
        this.zzabx().start();
    }

    public synchronized void zziS(String string) {
        this.zza((byte)1, string.getBytes(zzcjR));
    }

    synchronized void zzY(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.zzcjS != zza.zzckg) {
            this.zzcjU.zza(new zzbso("error while sending data: not connected"));
        } else {
            try {
                this.zzcjX.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.zzcjU.zza(new zzbso("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzbso zzbso2) {
        this.zzcjU.zza(zzbso2);
        if (this.zzcjS == zza.zzckg) {
            this.close();
        }
        this.zzabt();
    }

    public synchronized void close() {
        switch (this.zzcjS) {
            case zzcke: {
                this.zzcjS = zza.zzcki;
                return;
            }
            case zzckf: {
                this.zzabt();
                return;
            }
            case zzckg: {
                this.zzabu();
                return;
            }
            case zzckh: {
                return;
            }
            case zzcki: {
                return;
            }
        }
    }

    void zzabs() {
        this.zzabt();
    }

    private synchronized void zzabt() {
        if (this.zzcjS == zza.zzcki) {
            return;
        }
        this.zzcjW.zzabA();
        this.zzcjX.zzabD();
        if (this.zzcjT != null) {
            try {
                this.zzcjT.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzcjS = zza.zzcki;
        this.zzcjU.onClose();
    }

    private void zzabu() {
        try {
            this.zzcjS = zza.zzckh;
            this.zzcjX.zzabD();
            this.zzcjX.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.zzcjU.zza(new zzbso("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.zzcjV.getScheme();
        String string2 = this.zzcjV.getHost();
        int n = this.zzcjV.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzbso(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzcjV);
                throw new zzbso(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzcjV);
                    throw new zzbso(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzbso(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzcjV);
                throw new zzbso(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzbso(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void zzabv() throws InterruptedException {
        if (this.zzcjX.zzabx().getState() != Thread.State.NEW) {
            this.zzcjX.zzabx().join();
        }
        this.zzabx().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zzabw() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.zzcjT = socket;
                if (this.zzcjS == zza.zzcki) {
                    try {
                        this.zzcjT.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.zzcjT = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzcjY.zzaby());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzbso("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    object2 = new String(byArray, zzcjR);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                object2 = new String(byArray, zzcjR);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzbso(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzbso(string);
            }
            this.zzcjY.zzjc((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.zzcjY.zzc(hashMap);
            this.zzcjX.zzb(outputStream);
            this.zzcjW.zza((DataInputStream)object);
            this.zzcjS = zza.zzckg;
            this.zzcjX.zzabx().start();
            this.zzcjU.zzYd();
            this.zzcjW.run();
            return;
        }
        catch (zzbso zzbso2) {
            this.zzcjU.zza(zzbso2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzcjU.zza(new zzbso(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread zzabx() {
        return this.zzcjZ;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzcke = new zza();
        public static final /* enum */ zza zzckf = new zza();
        public static final /* enum */ zza zzckg = new zza();
        public static final /* enum */ zza zzckh = new zza();
        public static final /* enum */ zza zzcki = new zza();
        private static final /* synthetic */ zza[] zzckj;

        public static zza[] values() {
            return (zza[])zzckj.clone();
        }

        static {
            zzckj = new zza[]{zzcke, zzckf, zzckg, zzckh, zzcki};
        }
    }
}

