/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzejl;
import com.google.android.gms.internal.zzejn;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzejp;
import com.google.android.gms.internal.zzejq;
import com.google.android.gms.internal.zzejr;
import com.google.android.gms.internal.zzejs;
import com.google.android.gms.internal.zzejt;
import com.google.android.gms.internal.zzejv;
import com.google.android.gms.internal.zzejw;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class zzejm {
    private static final AtomicInteger zzmzk = new AtomicInteger(0);
    private static final Charset zzmzl = Charset.forName("UTF-8");
    private volatile int zzmzm = zzejq.zzmzx;
    private volatile Socket socket = null;
    private zzejr zzmzn = null;
    private final URI zzmzo;
    private final zzejv zzmzp;
    private final zzejw zzmzq;
    private final zzejt zzmzr;
    private final int zzflo = zzmzk.incrementAndGet();
    private final Thread zzmzs = zzmzt.newThread(new zzejo(this));
    private static ThreadFactory zzmzt = Executors.defaultThreadFactory();
    private static zzejl zzmzu = new zzejn();

    static ThreadFactory getThreadFactory() {
        return zzmzt;
    }

    static zzejl zzbyw() {
        return zzmzu;
    }

    public static void zza(ThreadFactory threadFactory, zzejl zzejl2) {
        zzmzt = threadFactory;
        zzmzu = zzejl2;
    }

    public zzejm(URI uRI, String string, Map<String, String> map) {
        this.zzmzo = uRI;
        this.zzmzr = new zzejt(uRI, null, map);
        this.zzmzp = new zzejv(this);
        this.zzmzq = new zzejw(this, "TubeSock", this.zzflo);
    }

    public final void zza(zzejr zzejr2) {
        this.zzmzn = zzejr2;
    }

    final zzejr zzbyx() {
        return this.zzmzn;
    }

    public final synchronized void connect() {
        if (this.zzmzm != zzejq.zzmzx) {
            this.zzmzn.zza(new zzejs("connect() already called"));
            this.close();
            return;
        }
        String string = "TubeSockReader-";
        int n = this.zzflo;
        zzmzu.zza(this.zzmzs, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzmzm = zzejq.zzmzy;
        this.zzmzs.start();
    }

    public final synchronized void zzpd(String string) {
        this.zza((byte)1, string.getBytes(zzmzl));
    }

    final synchronized void zzap(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzmzm != zzejq.zzmzz) {
            this.zzmzn.zza(new zzejs("error while sending data: not connected"));
            return;
        }
        try {
            this.zzmzq.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzmzn.zza(new zzejs("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzejs zzejs2) {
        this.zzmzn.zza(zzejs2);
        if (this.zzmzm == zzejq.zzmzz) {
            this.close();
        }
        this.zzbyz();
    }

    public final synchronized void close() {
        switch (zzejp.zzmzw[this.zzmzm - 1]) {
            case 1: {
                this.zzmzm = zzejq.zznab;
                return;
            }
            case 2: {
                this.zzbyz();
                return;
            }
            case 3: {
                zzejm zzejm2 = this;
                try {
                    zzejm2.zzmzm = zzejq.zznaa;
                    zzejm2.zzmzq.zzbzg();
                    zzejm2.zzmzq.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzejm2.zzmzn.zza(new zzejs("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzbyy() {
        this.zzbyz();
    }

    private final synchronized void zzbyz() {
        if (this.zzmzm == zzejq.zznab) {
            return;
        }
        this.zzmzp.zzbze();
        this.zzmzq.zzbzg();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzmzm = zzejq.zznab;
        this.zzmzn.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzmzo.getScheme();
        String string2 = this.zzmzo.getHost();
        int n = this.zzmzo.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzejs(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzmzo);
                throw new zzejs(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzmzo);
                    throw new zzejs(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzejs(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzmzo);
                throw new zzejs(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzejs(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzbza() throws InterruptedException {
        if (this.zzmzq.zzbzi().getState() != Thread.State.NEW) {
            this.zzmzq.zzbzi().join();
        }
        this.zzmzs.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzbzb() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzmzm == zzejq.zznab) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzmzr.zzbzc());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzejs("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzmzl);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzmzl);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzejs(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzejs(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzejs("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzejs("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzejs(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzejs("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzejs("connection failed: missing header field in server handshake: Connection");
            }
            this.zzmzq.zzb(outputStream);
            this.zzmzp.zza((DataInputStream)object);
            this.zzmzm = zzejq.zzmzz;
            this.zzmzq.zzbzi().start();
            this.zzmzn.zzbth();
            this.zzmzp.run();
            return;
        }
        catch (zzejs zzejs2) {
            this.zzmzn.zza(zzejs2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzmzn.zza(new zzejs(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzejm zzejm2) {
        zzejm2.zzbzb();
    }
}

