/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzdzt;
import com.google.android.gms.internal.zzehn;
import com.google.android.gms.internal.zzeje;
import com.google.android.gms.internal.zzejg;
import com.google.android.gms.internal.zzejh;
import com.google.android.gms.internal.zzeji;
import com.google.android.gms.internal.zzejj;
import com.google.android.gms.internal.zzejk;
import com.google.android.gms.internal.zzejl;
import com.google.android.gms.internal.zzejm;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzejp;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class zzejf {
    private static final AtomicInteger zzmyt = new AtomicInteger(0);
    private static final Charset zzmyu = Charset.forName("UTF-8");
    private volatile int zzmyv = zzejj.zzmzg;
    private volatile Socket socket = null;
    private zzejk zzmyw = null;
    private final URI zzmyx;
    @Nullable
    private final String zzmix;
    private final zzejo zzmyy;
    private final zzejp zzmyz;
    private final zzejm zzmza;
    private final zzehn zzmgu;
    private final int zzfle = zzmyt.incrementAndGet();
    private final Thread zzmzb = zzmzc.newThread(new zzejh(this));
    private static ThreadFactory zzmzc = Executors.defaultThreadFactory();
    private static zzeje zzmzd = new zzejg();

    static ThreadFactory getThreadFactory() {
        return zzmzc;
    }

    static zzeje zzbyu() {
        return zzmzd;
    }

    public zzejf(zzdzt zzdzt2, URI uRI, String string, Map<String, String> map) {
        this.zzmyx = uRI;
        this.zzmix = zzdzt2.zzbsi();
        int n = this.zzfle;
        this.zzmgu = new zzehn(zzdzt2.zzbsd(), "WebSocket", new StringBuilder(14).append("sk_").append(n).toString());
        this.zzmza = new zzejm(uRI, null, map);
        this.zzmyy = new zzejo(this);
        this.zzmyz = new zzejp(this, "TubeSock", this.zzfle);
    }

    public final void zza(zzejk zzejk2) {
        this.zzmyw = zzejk2;
    }

    final zzejk zzbyv() {
        return this.zzmyw;
    }

    public final synchronized void connect() {
        if (this.zzmyv != zzejj.zzmzg) {
            this.zzmyw.zza(new zzejl("connect() already called"));
            this.close();
            return;
        }
        String string = "TubeSockReader-";
        int n = this.zzfle;
        zzmzd.zza(this.zzmzb, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzmyv = zzejj.zzmzh;
        this.zzmzb.start();
    }

    public final synchronized void zzpc(String string) {
        this.zza((byte)1, string.getBytes(zzmyu));
    }

    final synchronized void zzap(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzmyv != zzejj.zzmzi) {
            this.zzmyw.zza(new zzejl("error while sending data: not connected"));
            return;
        }
        try {
            this.zzmyz.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzmyw.zza(new zzejl("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzejl zzejl2) {
        this.zzmyw.zza(zzejl2);
        if (this.zzmyv == zzejj.zzmzi) {
            this.close();
        }
        this.zzbyx();
    }

    public final synchronized void close() {
        switch (zzeji.zzmzf[this.zzmyv - 1]) {
            case 1: {
                this.zzmyv = zzejj.zzmzk;
                return;
            }
            case 2: {
                this.zzbyx();
                return;
            }
            case 3: {
                zzejf zzejf2 = this;
                try {
                    zzejf2.zzmyv = zzejj.zzmzj;
                    zzejf2.zzmyz.zzbze();
                    zzejf2.zzmyz.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzejf2.zzmyw.zza(new zzejl("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzbyw() {
        this.zzbyx();
    }

    private final synchronized void zzbyx() {
        if (this.zzmyv == zzejj.zzmzk) {
            return;
        }
        this.zzmyy.zzbzc();
        this.zzmyz.zzbze();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzmyv = zzejj.zzmzk;
        this.zzmyw.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzmyx.getScheme();
        String string2 = this.zzmyx.getHost();
        int n = this.zzmyx.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzejl(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzmyx);
                throw new zzejl(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        }
        if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            SSLSessionCache sSLSessionCache = null;
            try {
                if (this.zzmix != null) {
                    sSLSessionCache = new SSLSessionCache(new File(this.zzmix));
                }
            }
            catch (IOException iOException) {
                this.zzmgu.zzb("Failed to initialize SSL session cache", iOException, new Object[0]);
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLCertificateSocketFactory.getDefault((int)60000, sSLSessionCache).createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzmyx);
                    throw new zzejl(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzejl(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzmyx);
                throw new zzejl(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        }
        String string8 = String.valueOf(string);
        throw new zzejl(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        return socket;
    }

    public final void zzbyy() throws InterruptedException {
        if (this.zzmyz.zzbzg().getState() != Thread.State.NEW) {
            this.zzmyz.zzbzg().join();
        }
        this.zzmzb.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzbyz() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzmyv == zzejj.zzmzk) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzmza.zzbza());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzejl("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzmyu);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzmyu);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzejl(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzejl(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzejl("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzejl("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzejl(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzejl("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzejl("connection failed: missing header field in server handshake: Connection");
            }
            this.zzmyz.zzb(outputStream);
            this.zzmyy.zza((DataInputStream)object);
            this.zzmyv = zzejj.zzmzi;
            this.zzmyz.zzbzg().start();
            this.zzmyw.zzbti();
            this.zzmyy.run();
            return;
        }
        catch (zzejl zzejl2) {
            this.zzmyw.zza(zzejl2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzmyw.zza(new zzejl(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzejf zzejf2) {
        zzejf2.zzbyz();
    }
}

