/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzebi;
import com.google.android.gms.internal.zzejc;
import com.google.android.gms.internal.zzekt;
import com.google.android.gms.internal.zzekv;
import com.google.android.gms.internal.zzekw;
import com.google.android.gms.internal.zzekx;
import com.google.android.gms.internal.zzeky;
import com.google.android.gms.internal.zzekz;
import com.google.android.gms.internal.zzela;
import com.google.android.gms.internal.zzelb;
import com.google.android.gms.internal.zzeld;
import com.google.android.gms.internal.zzele;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class zzeku {
    private static final AtomicInteger zzndq = new AtomicInteger(0);
    private static final Charset zzndr = Charset.forName("UTF-8");
    private volatile int zznds = zzeky.zzned;
    private volatile Socket socket = null;
    private zzekz zzndt = null;
    private final URI zzndu;
    @Nullable
    private final String zzmnu;
    private final zzeld zzndv;
    private final zzele zzndw;
    private final zzelb zzndx;
    private final zzejc zzmlr;
    private final int zzfny = zzndq.incrementAndGet();
    private final Thread zzndy = zzndz.newThread(new zzekw(this));
    private static ThreadFactory zzndz = Executors.defaultThreadFactory();
    private static zzekt zznea = new zzekv();

    static ThreadFactory getThreadFactory() {
        return zzndz;
    }

    static zzekt zzcas() {
        return zznea;
    }

    public zzeku(zzebi zzebi2, URI uRI, String string, Map<String, String> map) {
        this.zzndu = uRI;
        this.zzmnu = zzebi2.zzbug();
        int n = this.zzfny;
        this.zzmlr = new zzejc(zzebi2.zzbub(), "WebSocket", new StringBuilder(14).append("sk_").append(n).toString());
        this.zzndx = new zzelb(uRI, null, map);
        this.zzndv = new zzeld(this);
        this.zzndw = new zzele(this, "TubeSock", this.zzfny);
    }

    public final void zza(zzekz zzekz2) {
        this.zzndt = zzekz2;
    }

    final zzekz zzcat() {
        return this.zzndt;
    }

    public final synchronized void connect() {
        if (this.zznds != zzeky.zzned) {
            this.zzndt.zza(new zzela("connect() already called"));
            this.close();
            return;
        }
        String string = "TubeSockReader-";
        int n = this.zzfny;
        zznea.zza(this.zzndy, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zznds = zzeky.zznee;
        this.zzndy.start();
    }

    public final synchronized void zzps(String string) {
        this.zza((byte)1, string.getBytes(zzndr));
    }

    final synchronized void zzaq(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zznds != zzeky.zznef) {
            this.zzndt.zza(new zzela("error while sending data: not connected"));
            return;
        }
        try {
            this.zzndw.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzndt.zza(new zzela("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzela zzela2) {
        this.zzndt.zza(zzela2);
        if (this.zznds == zzeky.zznef) {
            this.close();
        }
        this.zzcav();
    }

    public final synchronized void close() {
        switch (zzekx.zznec[this.zznds - 1]) {
            case 1: {
                this.zznds = zzeky.zzneh;
                return;
            }
            case 2: {
                this.zzcav();
                return;
            }
            case 3: {
                zzeku zzeku2 = this;
                try {
                    zzeku2.zznds = zzeky.zzneg;
                    zzeku2.zzndw.zzcbc();
                    zzeku2.zzndw.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzeku2.zzndt.zza(new zzela("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzcau() {
        this.zzcav();
    }

    private final synchronized void zzcav() {
        if (this.zznds == zzeky.zzneh) {
            return;
        }
        this.zzndv.zzcba();
        this.zzndw.zzcbc();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zznds = zzeky.zzneh;
        this.zzndt.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzndu.getScheme();
        String string2 = this.zzndu.getHost();
        int n = this.zzndu.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzela(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzndu);
                throw new zzela(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        }
        if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            SSLSessionCache sSLSessionCache = null;
            try {
                if (this.zzmnu != null) {
                    sSLSessionCache = new SSLSessionCache(new File(this.zzmnu));
                }
            }
            catch (IOException iOException) {
                this.zzmlr.zzb("Failed to initialize SSL session cache", iOException, new Object[0]);
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLCertificateSocketFactory.getDefault((int)60000, sSLSessionCache).createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzndu);
                    throw new zzela(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzela(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzndu);
                throw new zzela(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        }
        String string8 = String.valueOf(string);
        throw new zzela(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        return socket;
    }

    public final void zzcaw() throws InterruptedException {
        if (this.zzndw.zzcbe().getState() != Thread.State.NEW) {
            this.zzndw.zzcbe().join();
        }
        this.zzndy.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzcax() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zznds == zzeky.zzneh) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzndx.zzcay());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzela("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzndr);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzndr);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzela(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzela(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzela("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzela("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzela(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzela("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzela("connection failed: missing header field in server handshake: Connection");
            }
            this.zzndw.zzb(outputStream);
            this.zzndv.zza((DataInputStream)object);
            this.zznds = zzeky.zznef;
            this.zzndw.zzcbe().start();
            this.zzndt.zzbvg();
            this.zzndv.run();
            return;
        }
        catch (zzela zzela2) {
            this.zzndt.zza(zzela2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzndt.zza(new zzela(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzeku zzeku2) {
        zzeku2.zzcax();
    }
}

