/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzees;
import com.google.android.gms.internal.zzemm;
import com.google.android.gms.internal.zzeod;
import com.google.android.gms.internal.zzeof;
import com.google.android.gms.internal.zzeog;
import com.google.android.gms.internal.zzeoh;
import com.google.android.gms.internal.zzeoi;
import com.google.android.gms.internal.zzeoj;
import com.google.android.gms.internal.zzeok;
import com.google.android.gms.internal.zzeol;
import com.google.android.gms.internal.zzeon;
import com.google.android.gms.internal.zzeoo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class zzeoe {
    private static final AtomicInteger zza = new AtomicInteger(0);
    private static final Charset zzb = Charset.forName("UTF-8");
    private volatile int zzc = zzeoi.zza;
    private volatile Socket zzd = null;
    private zzeoj zze = null;
    private final URI zzf;
    @Nullable
    private final String zzg;
    private final zzeon zzh;
    private final zzeoo zzi;
    private final zzeol zzj;
    private final zzemm zzk;
    private final int zzl = zza.incrementAndGet();
    private final Thread zzm = zzn.newThread(new zzeog(this));
    private static ThreadFactory zzn = Executors.defaultThreadFactory();
    private static zzeod zzo = new zzeof();

    static ThreadFactory zza() {
        return zzn;
    }

    static zzeod zzb() {
        return zzo;
    }

    public zzeoe(zzees zzees2, URI uRI, String string, Map<String, String> map) {
        this.zzf = uRI;
        this.zzg = zzees2.zzg();
        int n = this.zzl;
        this.zzk = new zzemm(zzees2.zza(), "WebSocket", new StringBuilder(14).append("sk_").append(n).toString());
        this.zzj = new zzeol(uRI, null, map);
        this.zzh = new zzeon(this);
        this.zzi = new zzeoo(this, "TubeSock", this.zzl);
    }

    public final void zza(zzeoj zzeoj2) {
        this.zze = zzeoj2;
    }

    final zzeoj zzc() {
        return this.zze;
    }

    public final synchronized void zzd() {
        if (this.zzc != zzeoi.zza) {
            this.zze.zza(new zzeok("connect() already called"));
            this.zze();
            return;
        }
        int n = this.zzl;
        zzo.zza(this.zzm, new StringBuilder(26).append("TubeSockReader-").append(n).toString());
        this.zzc = zzeoi.zzb;
        this.zzm.start();
    }

    public final synchronized void zza(String string) {
        this.zza((byte)1, string.getBytes(zzb));
    }

    final synchronized void zza(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzc != zzeoi.zzc) {
            this.zze.zza(new zzeok("error while sending data: not connected"));
            return;
        }
        try {
            this.zzi.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zze.zza(new zzeok("Failed to send frame", iOException));
            this.zze();
            return;
        }
    }

    final void zza(zzeok zzeok2) {
        this.zze.zza(zzeok2);
        if (this.zzc == zzeoi.zzc) {
            this.zze();
        }
        this.zzh();
    }

    public final synchronized void zze() {
        switch (zzeoh.zza[this.zzc - 1]) {
            case 1: {
                this.zzc = zzeoi.zze;
                return;
            }
            case 2: {
                this.zzh();
                return;
            }
            case 3: {
                zzeoe zzeoe2 = this;
                try {
                    zzeoe2.zzc = zzeoi.zzd;
                    zzeoe2.zzi.zza();
                    zzeoe2.zzi.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzeoe2.zze.zza(new zzeok("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzf() {
        this.zzh();
    }

    private final synchronized void zzh() {
        if (this.zzc == zzeoi.zze) {
            return;
        }
        this.zzh.zzb();
        this.zzi.zza();
        if (this.zzd != null) {
            try {
                this.zzd.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzc = zzeoi.zze;
        this.zze.zzd();
    }

    private final Socket zzi() {
        Socket socket;
        String string = this.zzf.getScheme();
        String string2 = this.zzf.getHost();
        int n = this.zzf.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzeok(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzf);
                throw new zzeok(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        }
        if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            SSLSessionCache sSLSessionCache = null;
            try {
                if (this.zzg != null) {
                    sSLSessionCache = new SSLSessionCache(new File(this.zzg));
                }
            }
            catch (IOException iOException) {
                this.zzk.zza("Failed to initialize SSL session cache", iOException, new Object[0]);
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLCertificateSocketFactory.getDefault((int)60000, sSLSessionCache).createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzf);
                    throw new zzeok(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzeok(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzf);
                throw new zzeok(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        }
        String string8 = String.valueOf(string);
        throw new zzeok(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        return socket;
    }

    public final void zzg() throws InterruptedException {
        if (this.zzi.zzb().getState() != Thread.State.NEW) {
            this.zzi.zzb().join();
        }
        this.zzm.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzj() {
        try {
            Socket socket = this.zzi();
            Object object = this;
            synchronized (object) {
                this.zzd = socket;
                if (this.zzc == zzeoi.zze) {
                    try {
                        this.zzd.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.zzd = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzj.zza());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzeok("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzb);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzb);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzeok(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzeok(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzeok("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzeok("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzeok(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzeok("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzeok("connection failed: missing header field in server handshake: Connection");
            }
            this.zzi.zza(outputStream);
            this.zzh.zza((DataInputStream)object);
            this.zzc = zzeoi.zzc;
            this.zzi.zzb().start();
            this.zze.zzc();
            this.zzh.zza();
            return;
        }
        catch (zzeok zzeok2) {
            this.zze.zza(zzeok2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zze.zza(new zzeok(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.zze();
        }
    }

    static /* synthetic */ void zza(zzeoe zzeoe2) {
        zzeoe2.zzj();
    }
}

