/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzags;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahc;
import com.google.android.gms.internal.zzaju;
import com.google.android.gms.internal.zzakt;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzakv;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzalc;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzaha {
    private static long aRS = 0L;
    private zzb aRT;
    private boolean aRU = false;
    private boolean aRV = false;
    private long aRW = 0L;
    private zzahc aRX;
    private zza aRY;
    private ScheduledFuture<?> aRZ;
    private ScheduledFuture<?> aSa;
    private final zzags aSb;
    private final ScheduledExecutorService aPC;
    private final zzaju aPP;

    public zzaha(zzags zzags2, zzagu zzagu2, String string, zza zza2, String string2) {
        this.aSb = zzags2;
        this.aPC = zzags2.zzcob();
        this.aRY = zza2;
        long l = aRS++;
        this.aPP = new zzaju(zzags2.zzcnz(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.aRT = this.zza(zzagu2, string, string2);
    }

    private zzb zza(zzagu zzagu2, String string, String string2) {
        String string3 = string != null ? string : zzagu2.getHost();
        URI uRI = zzagu.zza(string3, zzagu2.isSecure(), zzagu2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.aSb.zzso());
        zzakt zzakt2 = new zzakt(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzakt2);
        return zzc2;
    }

    public void open() {
        this.aRT.connect();
        this.aSa = this.aPC.schedule(new Runnable(){

            @Override
            public void run() {
                zzaha.this.zzcpi();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void close() {
        if (this.aPP.zzcuk()) {
            this.aPP.zzi("websocket is being closed", new Object[0]);
        }
        this.aRV = true;
        this.aRT.close();
        if (this.aSa != null) {
            this.aSa.cancel(true);
        }
        if (this.aRZ != null) {
            this.aRZ.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzcpf();
        try {
            int n;
            String string = zzalc.zzcb(map);
            String[] stringArray = zzaha.zzad(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.aRT.zzrv(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.aRT.zzrv(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.aPP.zze(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zzrs(String string) {
        this.aRX.zzrw(string);
        --this.aRW;
        if (this.aRW == 0L) {
            try {
                this.aRX.zzcpo();
                Map<String, Object> map = zzalc.zzsg(this.aRX.toString());
                this.aRX = null;
                if (this.aPP.zzcuk()) {
                    String string2 = String.valueOf(map);
                    this.aPP.zzi(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.aRY.zzbp(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.aRX.toString());
                this.aPP.zze(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.aRX.toString());
                this.aPP.zze(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzaes(int n) {
        this.aRW = n;
        this.aRX = new zzahc();
        if (this.aPP.zzcuk()) {
            long l = this.aRW;
            this.aPP.zzi(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zzrt(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzaes(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.zzaes(1);
        return string;
    }

    private void zzru(String string) {
        if (!this.aRV) {
            this.zzcpf();
            if (this.isBuffering()) {
                this.zzrs(string);
            } else {
                String string2 = this.zzrt(string);
                if (string2 != null) {
                    this.zzrs(string2);
                }
            }
        }
    }

    private void zzcpf() {
        if (!this.aRV) {
            if (this.aRZ != null) {
                this.aRZ.cancel(false);
                if (this.aPP.zzcuk()) {
                    long l = this.aRZ.getDelay(TimeUnit.MILLISECONDS);
                    this.aPP.zzi(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.aPP.zzcuk()) {
                this.aPP.zzi("Reset keepAlive", new Object[0]);
            }
            this.aRZ = this.aPC.schedule(this.zzcpg(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzcpg() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzaha.this.aRT != null) {
                    zzaha.this.aRT.zzrv("0");
                    zzaha.this.zzcpf();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.aRX != null;
    }

    private void zzcph() {
        if (!this.aRV) {
            if (this.aPP.zzcuk()) {
                this.aPP.zzi("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.aRT = null;
        if (this.aRZ != null) {
            this.aRZ.cancel(false);
        }
    }

    private void shutdown() {
        this.aRV = true;
        this.aRY.zzcp(this.aRU);
    }

    private void zzcpi() {
        if (!this.aRU && !this.aRV) {
            if (this.aPP.zzcuk()) {
                this.aPP.zzi("timed out on connect", new Object[0]);
            }
            this.aRT.close();
        }
    }

    private static String[] zzad(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzaku {
        private zzakt aSd;

        private zzc(zzakt zzakt2) {
            this.aSd = zzakt2;
            this.aSd.zza(this);
        }

        @Override
        public void zzcpj() {
            zzaha.this.aPC.execute(new Runnable(){

                @Override
                public void run() {
                    zzaha.this.aSa.cancel(false);
                    zzaha.this.aRU = true;
                    if (zzaha.this.aPP.zzcuk()) {
                        zzaha.this.aPP.zzi("websocket opened", new Object[0]);
                    }
                    zzaha.this.zzcpf();
                }
            });
        }

        @Override
        public void zza(zzakx zzakx2) {
            final String string = zzakx2.getText();
            if (zzaha.this.aPP.zzcuk()) {
                String string2 = String.valueOf(string);
                zzaha.this.aPP.zzi(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzaha.this.aPC.execute(new Runnable(){

                @Override
                public void run() {
                    zzaha.this.zzru(string);
                }
            });
        }

        @Override
        public void onClose() {
            String string = "closed";
            zzaha.this.aPC.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzaha.this.aPP.zzcuk()) {
                        zzaha.this.aPP.zzi("closed", new Object[0]);
                    }
                    zzaha.this.zzcph();
                }
            });
        }

        @Override
        public void zza(final zzakv zzakv2) {
            zzaha.this.aPC.execute(new Runnable(){

                @Override
                public void run() {
                    String string = "had an error";
                    if (zzaha.this.aPP.zzcuk()) {
                        zzaha.this.aPP.zza(string, zzakv2, new Object[0]);
                    }
                    if (zzakv2.getMessage().startsWith("unknown host")) {
                        if (zzaha.this.aPP.zzcuk()) {
                            zzaha.this.aPP.zzi("If you are running on Android, have you added <uses-permission android:name=\"android.permission.INTERNET\" /> under <manifest> in AndroidManifest.xml?", new Object[0]);
                        }
                    } else if (zzaha.this.aPP.zzcuk()) {
                        String string2 = String.valueOf(zzakv2.getMessage());
                        zzaha.this.aPP.zzi(new StringBuilder(2 + String.valueOf(string2).length()).append("|").append(string2).append("|").toString(), new Object[0]);
                    }
                    zzaha.this.zzcph();
                }
            });
        }

        @Override
        public void zzrv(String string) {
            this.aSd.zzrv(string);
        }

        @Override
        public void close() {
            this.aSd.close();
        }

        private void shutdown() {
            this.aSd.close();
            try {
                this.aSd.zzcwc();
            }
            catch (InterruptedException interruptedException) {
                zzaha.this.aPP.zze("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.aSd.connect();
            }
            catch (zzakv zzakv2) {
                if (zzaha.this.aPP.zzcuk()) {
                    zzaha.this.aPP.zza("Error connecting", zzakv2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zzrv(String var1);
    }

    public static interface zza {
        public void zzbp(Map<String, Object> var1);

        public void zzcp(boolean var1);
    }
}

