/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaks;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzakv;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzakz;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzakt {
    private static final AtomicInteger aZo = new AtomicInteger(0);
    private static final Charset aZp = Charset.forName("UTF-8");
    private volatile zza aZq = zza.aZC;
    private volatile Socket aZr = null;
    private zzaku aZs = null;
    private final URI aZt;
    private final zzaky aZu;
    private final zzakz aZv;
    private final zzakw aZw;
    private final int sD = aZo.incrementAndGet();
    private final Thread aZx = zzakt.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzakt.this.zzcwd();
        }
    });
    private static ThreadFactory aZy = Executors.defaultThreadFactory();
    private static zzaks aZz = new zzaks(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return aZy;
    }

    static zzaks zzcvx() {
        return aZz;
    }

    public static void zza(ThreadFactory threadFactory, zzaks zzaks2) {
        aZy = threadFactory;
        aZz = zzaks2;
    }

    public zzakt(URI uRI, String string, Map<String, String> map) {
        this.aZt = uRI;
        this.aZw = new zzakw(uRI, string, map);
        this.aZu = new zzaky(this);
        this.aZv = new zzakz(this, "TubeSock", this.sD);
    }

    public void zza(zzaku zzaku2) {
        this.aZs = zzaku2;
    }

    zzaku zzcvy() {
        return this.aZs;
    }

    public synchronized void connect() {
        if (this.aZq != zza.aZC) {
            this.aZs.zza(new zzakv("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.sD;
        zzakt.zzcvx().zza(this.zzcwe(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.aZq = zza.aZD;
        this.zzcwe().start();
    }

    public synchronized void zzrv(String string) {
        this.zza((byte)1, string.getBytes(aZp));
    }

    synchronized void zzav(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.aZq != zza.aZE) {
            this.aZs.zza(new zzakv("error while sending data: not connected"));
        } else {
            try {
                this.aZv.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.aZs.zza(new zzakv("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzakv zzakv2) {
        this.aZs.zza(zzakv2);
        if (this.aZq == zza.aZE) {
            this.close();
        }
        this.zzcwa();
    }

    public synchronized void close() {
        switch (this.aZq) {
            case aZC: {
                this.aZq = zza.aZG;
                return;
            }
            case aZD: {
                this.zzcwa();
                return;
            }
            case aZE: {
                this.zzcwb();
                return;
            }
            case aZF: {
                return;
            }
            case aZG: {
                return;
            }
        }
    }

    void zzcvz() {
        this.zzcwa();
    }

    private synchronized void zzcwa() {
        if (this.aZq == zza.aZG) {
            return;
        }
        this.aZu.zzcwh();
        this.aZv.zzcwk();
        if (this.aZr != null) {
            try {
                this.aZr.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.aZq = zza.aZG;
        this.aZs.onClose();
    }

    private void zzcwb() {
        try {
            this.aZq = zza.aZF;
            this.aZv.zzcwk();
            this.aZv.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.aZs.zza(new zzakv("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.aZt.getScheme();
        String string2 = this.aZt.getHost();
        int n = this.aZt.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzakv(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.aZt);
                throw new zzakv(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.aZt);
                    throw new zzakv(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzakv(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.aZt);
                throw new zzakv(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzakv(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void zzcwc() throws InterruptedException {
        if (this.aZv.zzcwe().getState() != Thread.State.NEW) {
            this.aZv.zzcwe().join();
        }
        this.zzcwe().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zzcwd() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.aZr = socket;
                if (this.aZq == zza.aZG) {
                    try {
                        this.aZr.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.aZr = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.aZw.zzcwf());
            boolean bl = false;
            int n = 1000;
            byte[] byArray = new byte[1000];
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n3 = ((FilterInputStream)object).read();
                if (n3 == -1) {
                    throw new zzakv("Connection closed before handshake was complete");
                }
                byArray[n2] = (byte)n3;
                if (byArray[++n2 - 1] == 10 && byArray[n2 - 2] == 13) {
                    object2 = new String(byArray, aZp);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n2 = 0;
                    continue;
                }
                if (n2 != 1000) continue;
                object2 = new String(byArray, aZp);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzakv(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzakv(string);
            }
            this.aZw.zzse((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.aZw.zzc(hashMap);
            this.aZv.zzb(outputStream);
            this.aZu.zza((DataInputStream)object);
            this.aZq = zza.aZE;
            this.aZv.zzcwe().start();
            this.aZs.zzcpj();
            this.aZu.run();
            return;
        }
        catch (zzakv zzakv2) {
            this.aZs.zza(zzakv2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.aZs.zza(new zzakv(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread zzcwe() {
        return this.aZx;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza aZC = new zza();
        public static final /* enum */ zza aZD = new zza();
        public static final /* enum */ zza aZE = new zza();
        public static final /* enum */ zza aZF = new zza();
        public static final /* enum */ zza aZG = new zza();
        private static final /* synthetic */ zza[] aZH;

        public static zza[] values() {
            return (zza[])aZH.clone();
        }

        static {
            aZH = new zza[]{aZC, aZD, aZE, aZF, aZG};
        }
    }
}

