/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaid;
import com.google.android.gms.internal.zzaif;
import com.google.android.gms.internal.zzain;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzamf;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamn;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzail {
    private static long aYK = 0L;
    private zzb aYL;
    private boolean aYM = false;
    private boolean aYN = false;
    private long aYO = 0L;
    private zzain aYP;
    private zza aYQ;
    private ScheduledFuture<?> aYR;
    private ScheduledFuture<?> aYS;
    private final zzaid aYT;
    private final ScheduledExecutorService aWs;
    private final zzalf aWF;

    public zzail(zzaid zzaid2, zzaif zzaif2, String string, zza zza2, String string2) {
        this.aYT = zzaid2;
        this.aWs = zzaid2.zzcsh();
        this.aYQ = zza2;
        long l = aYK++;
        this.aWF = new zzalf(zzaid2.zzcsf(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.aYL = this.zza(zzaif2, string, string2);
    }

    private zzb zza(zzaif zzaif2, String string, String string2) {
        String string3 = string != null ? string : zzaif2.getHost();
        URI uRI = zzaif.zza(string3, zzaif2.isSecure(), zzaif2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.aYT.zztp());
        zzame zzame2 = new zzame(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzame2);
        return zzc2;
    }

    public void open() {
        this.aYL.connect();
        this.aYS = this.aWs.schedule(new Runnable(){

            @Override
            public void run() {
                zzail.this.zzctq();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void close() {
        if (this.aWF.zzcys()) {
            this.aWF.zzi("websocket is being closed", new Object[0]);
        }
        this.aYN = true;
        this.aYL.close();
        if (this.aYS != null) {
            this.aYS.cancel(true);
        }
        if (this.aYR != null) {
            this.aYR.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzctn();
        try {
            int n;
            String string = zzamn.zzcc(map);
            String[] stringArray = zzail.zzae(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.aYL.zzsq(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.aYL.zzsq(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.aWF.zze(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zzsn(String string) {
        this.aYP.zzsr(string);
        --this.aYO;
        if (this.aYO == 0L) {
            try {
                this.aYP.zzctx();
                Map<String, Object> map = zzamn.zztc(this.aYP.toString());
                this.aYP = null;
                if (this.aWF.zzcys()) {
                    String string2 = String.valueOf(map);
                    this.aWF.zzi(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.aYQ.zzbq(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.aYP.toString());
                this.aWF.zze(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.aYP.toString());
                this.aWF.zze(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzagc(int n) {
        this.aYO = n;
        this.aYP = new zzain();
        if (this.aWF.zzcys()) {
            long l = this.aYO;
            this.aWF.zzi(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zzso(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzagc(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.zzagc(1);
        return string;
    }

    private void zzsp(String string) {
        if (!this.aYN) {
            this.zzctn();
            if (this.isBuffering()) {
                this.zzsn(string);
            } else {
                String string2 = this.zzso(string);
                if (string2 != null) {
                    this.zzsn(string2);
                }
            }
        }
    }

    private void zzctn() {
        if (!this.aYN) {
            if (this.aYR != null) {
                this.aYR.cancel(false);
                if (this.aWF.zzcys()) {
                    long l = this.aYR.getDelay(TimeUnit.MILLISECONDS);
                    this.aWF.zzi(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.aWF.zzcys()) {
                this.aWF.zzi("Reset keepAlive", new Object[0]);
            }
            this.aYR = this.aWs.schedule(this.zzcto(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzcto() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzail.this.aYL != null) {
                    zzail.this.aYL.zzsq("0");
                    zzail.this.zzctn();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.aYP != null;
    }

    private void zzctp() {
        if (!this.aYN) {
            if (this.aWF.zzcys()) {
                this.aWF.zzi("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.aYL = null;
        if (this.aYR != null) {
            this.aYR.cancel(false);
        }
    }

    private void shutdown() {
        this.aYN = true;
        this.aYQ.zzcu(this.aYM);
    }

    private void zzctq() {
        if (!this.aYM && !this.aYN) {
            if (this.aWF.zzcys()) {
                this.aWF.zzi("timed out on connect", new Object[0]);
            }
            this.aYL.close();
        }
    }

    private static String[] zzae(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzamf {
        private zzame aYV;

        private zzc(zzame zzame2) {
            this.aYV = zzame2;
            this.aYV.zza(this);
        }

        @Override
        public void zzctr() {
            zzail.this.aWs.execute(new Runnable(){

                @Override
                public void run() {
                    zzail.this.aYS.cancel(false);
                    zzail.this.aYM = true;
                    if (zzail.this.aWF.zzcys()) {
                        zzail.this.aWF.zzi("websocket opened", new Object[0]);
                    }
                    zzail.this.zzctn();
                }
            });
        }

        @Override
        public void zza(zzami zzami2) {
            final String string = zzami2.getText();
            if (zzail.this.aWF.zzcys()) {
                String string2 = String.valueOf(string);
                zzail.this.aWF.zzi(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzail.this.aWs.execute(new Runnable(){

                @Override
                public void run() {
                    zzail.this.zzsp(string);
                }
            });
        }

        @Override
        public void onClose() {
            String string = "closed";
            zzail.this.aWs.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzail.this.aWF.zzcys()) {
                        zzail.this.aWF.zzi("closed", new Object[0]);
                    }
                    zzail.this.zzctp();
                }
            });
        }

        @Override
        public void zza(final zzamg zzamg2) {
            zzail.this.aWs.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzamg2.getCause() != null && zzamg2.getCause() instanceof EOFException) {
                        zzail.this.aWF.zzi("WebSocket reached EOF.", new Object[0]);
                    } else {
                        zzail.this.aWF.zza("WebSocket error.", zzamg2, new Object[0]);
                    }
                    zzail.this.zzctp();
                }
            });
        }

        @Override
        public void zzsq(String string) {
            this.aYV.zzsq(string);
        }

        @Override
        public void close() {
            this.aYV.close();
        }

        private void shutdown() {
            this.aYV.close();
            try {
                this.aYV.k();
            }
            catch (InterruptedException interruptedException) {
                zzail.this.aWF.zze("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.aYV.connect();
            }
            catch (zzamg zzamg2) {
                if (zzail.this.aWF.zzcys()) {
                    zzail.this.aWF.zza("Error connecting", zzamg2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zzsq(String var1);
    }

    public static interface zza {
        public void zzbq(Map<String, Object> var1);

        public void zzcu(boolean var1);
    }
}

