/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzana;
import com.google.android.gms.internal.zzanb;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzamv {
    private static final AtomicInteger bjs = new AtomicInteger(0);
    private static final Charset bjt = Charset.forName("UTF-8");
    private volatile zza bju = zza.bjG;
    private volatile Socket bjv = null;
    private zzamw bjw = null;
    private final URI bjx;
    private final zzana bjy;
    private final zzanb bjz;
    private final zzamy bjA;
    private final int yr = bjs.incrementAndGet();
    private final Thread bjB = zzamv.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzamv.this.n();
        }
    });
    private static ThreadFactory bjC = Executors.defaultThreadFactory();
    private static zzamu bjD = new zzamu(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return bjC;
    }

    static zzamu h() {
        return bjD;
    }

    public static void zza(ThreadFactory threadFactory, zzamu zzamu2) {
        bjC = threadFactory;
        bjD = zzamu2;
    }

    public zzamv(URI uRI, String string, Map<String, String> map) {
        this.bjx = uRI;
        this.bjA = new zzamy(uRI, string, map);
        this.bjy = new zzana(this);
        this.bjz = new zzanb(this, "TubeSock", this.yr);
    }

    public void zza(zzamw zzamw2) {
        this.bjw = zzamw2;
    }

    zzamw i() {
        return this.bjw;
    }

    public synchronized void connect() {
        if (this.bju != zza.bjG) {
            this.bjw.zza(new zzamx("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.yr;
        zzamv.h().zza(this.o(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.bju = zza.bjH;
        this.o().start();
    }

    public synchronized void zzsp(String string) {
        this.zza((byte)1, string.getBytes(bjt));
    }

    synchronized void zzaw(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.bju != zza.bjI) {
            this.bjw.zza(new zzamx("error while sending data: not connected"));
        } else {
            try {
                this.bjz.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.bjw.zza(new zzamx("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzamx zzamx2) {
        this.bjw.zza(zzamx2);
        if (this.bju == zza.bjI) {
            this.close();
        }
        this.k();
    }

    public synchronized void close() {
        switch (this.bju) {
            case bjG: {
                this.bju = zza.bjK;
                return;
            }
            case bjH: {
                this.k();
                return;
            }
            case bjI: {
                this.l();
                return;
            }
            case bjJ: {
                return;
            }
            case bjK: {
                return;
            }
        }
    }

    void j() {
        this.k();
    }

    private synchronized void k() {
        if (this.bju == zza.bjK) {
            return;
        }
        this.bjy.r();
        this.bjz.u();
        if (this.bjv != null) {
            try {
                this.bjv.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.bju = zza.bjK;
        this.bjw.onClose();
    }

    private void l() {
        try {
            this.bju = zza.bjJ;
            this.bjz.u();
            this.bjz.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.bjw.zza(new zzamx("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.bjx.getScheme();
        String string2 = this.bjx.getHost();
        int n = this.bjx.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzamx(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.bjx);
                throw new zzamx(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.bjx);
                    throw new zzamx(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzamx(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.bjx);
                throw new zzamx(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzamx(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void m() throws InterruptedException {
        if (this.bjz.o().getState() != Thread.State.NEW) {
            this.bjz.o().join();
        }
        this.o().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void n() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.bjv = socket;
                if (this.bju == zza.bjK) {
                    try {
                        this.bjv.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.bjv = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.bjA.p());
            boolean bl = false;
            int n = 1000;
            byte[] byArray = new byte[1000];
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n3 = ((FilterInputStream)object).read();
                if (n3 == -1) {
                    throw new zzamx("Connection closed before handshake was complete");
                }
                byArray[n2] = (byte)n3;
                if (byArray[++n2 - 1] == 10 && byArray[n2 - 2] == 13) {
                    object2 = new String(byArray, bjt);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n2 = 0;
                    continue;
                }
                if (n2 != 1000) continue;
                object2 = new String(byArray, bjt);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzamx(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzamx(string);
            }
            this.bjA.zzsz((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.bjA.zzd(hashMap);
            this.bjz.zzb(outputStream);
            this.bjy.zza((DataInputStream)object);
            this.bju = zza.bjI;
            this.bjz.o().start();
            this.bjw.zzctt();
            this.bjy.run();
            return;
        }
        catch (zzamx zzamx2) {
            this.bjw.zza(zzamx2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.bjw.zza(new zzamx(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread o() {
        return this.bjB;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza bjG = new zza();
        public static final /* enum */ zza bjH = new zza();
        public static final /* enum */ zza bjI = new zza();
        public static final /* enum */ zza bjJ = new zza();
        public static final /* enum */ zza bjK = new zza();
        private static final /* synthetic */ zza[] bjL;

        public static zza[] values() {
            return (zza[])bjL.clone();
        }

        static {
            bjL = new zza[]{bjG, bjH, bjI, bjJ, bjK};
        }
    }
}

