/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzbma;
import com.google.android.gms.internal.zzbmd;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbml;
import com.google.android.gms.internal.zzbmn;
import com.google.android.gms.internal.zzbmy;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbpe;
import com.google.android.gms.internal.zzbpf;
import com.google.android.gms.internal.zzbpi;
import com.google.android.gms.internal.zzbqd;
import com.google.android.gms.internal.zzbqf;
import com.google.android.gms.internal.zzbqg;
import com.google.android.gms.internal.zzbqh;
import com.google.android.gms.internal.zzbqi;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzbmd zzbXE;

    DatabaseReference(zzbml zzbml2, zzbmj zzbmj2) {
        super(zzbml2, zzbmj2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzVc().isEmpty()) {
            zzbqh.zzjn(string);
        } else {
            zzbqh.zzjm(string);
        }
        zzbmj zzbmj2 = this.zzVc().zzh(new zzbmj(string));
        return new DatabaseReference(this.zzbXR, zzbmj2);
    }

    public DatabaseReference push() {
        String string = zzbqf.zzaQ(this.zzbXR.zzXp());
        zzbos zzbos2 = zzbos.zzjb(string);
        return new DatabaseReference(this.zzbXR, this.zzVc().zza(zzbos2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzbpi.zzas(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzbpi.zzas(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzbpi.zzas(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzbpi.zzas(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzbpe zzbpe2, CompletionListener completionListener) {
        zzbqh.zzQ(this.zzVc());
        zzbmy.zza(this.zzVc(), object);
        Object object2 = zzbqi.zzaw(object);
        zzbqh.zzav(object2);
        final zzbpe zzbpe3 = zzbpf.zza(object2, zzbpe2);
        final zzbqd<Task<Void>, CompletionListener> zzbqd2 = zzbqg.zzb(completionListener);
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbXR.zza(DatabaseReference.this.zzVc(), zzbpe3, (CompletionListener)zzbqd2.zzZZ());
            }
        });
        return zzbqd2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzbpi.zzas(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzbpi.zzas(object), completionListener);
    }

    private Task<Void> zza(final zzbpe zzbpe2, CompletionListener completionListener) {
        zzbqh.zzQ(this.zzVc());
        final zzbqd<Task<Void>, CompletionListener> zzbqd2 = zzbqg.zzb(completionListener);
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbXR.zza(DatabaseReference.this.zzVc().zza(zzbos.zzYY()), zzbpe2, (CompletionListener)zzbqd2.zzZZ());
            }
        });
        return zzbqd2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        final Map<String, Object> map2 = zzbqi.zzaF(map);
        Map<zzbmj, zzbpe> map3 = zzbqh.zzc(this.zzVc(), map2);
        final zzbma zzbma2 = zzbma.zzaB(map3);
        final zzbqd<Task<Void>, CompletionListener> zzbqd2 = zzbqg.zzb(completionListener);
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbXR.zza(DatabaseReference.this.zzVc(), zzbma2, (CompletionListener)zzbqd2.zzZZ(), (Map<String, Object>)map2);
            }
        });
        return zzbqd2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzbqh.zzQ(this.zzVc());
        return new OnDisconnect(this.zzbXR, this.zzVc());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzbqh.zzQ(this.zzVc());
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbXR.zza(DatabaseReference.this.zzVc(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzUW());
    }

    static void zza(zzbmd zzbmd2) {
        zzbmn.zzd(zzbmd2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzUW());
    }

    static void zzb(zzbmd zzbmd2) {
        zzbmn.zze(zzbmd2);
    }

    public FirebaseDatabase getDatabase() {
        return this.zzbXR.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzbXR.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzbmj zzbmj2 = this.zzVc().zzXk();
        if (zzbmj2 != null) {
            return new DatabaseReference(this.zzbXR, zzbmj2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzbXR, new zzbmj(""));
    }

    public String getKey() {
        if (this.zzVc().isEmpty()) {
            return null;
        }
        return this.zzVc().zzXl().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzbmd zzUW() {
        if (zzbXE == null) {
            zzbXE = new zzbmd();
        }
        return zzbXE;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

