/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzbmd;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbml;
import com.google.android.gms.internal.zzbmm;
import com.google.android.gms.internal.zzbmn;
import com.google.android.gms.internal.zzbqe;
import com.google.android.gms.internal.zzbqg;
import com.google.android.gms.internal.zzbqh;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, FirebaseDatabase> zzbXN = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp zzbXO;
    private final zzbmm zzbXP;
    private final zzbmd zzbXQ;
    private zzbml zzbXR;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        if (!zzbXN.containsKey(firebaseApp.getName())) {
            String string = firebaseApp.getOptions().getDatabaseUrl();
            if (string == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            zzbqe zzbqe2 = zzbqg.zzjh(string);
            if (!zzbqe2.zzbXY.isEmpty()) {
                String string2 = String.valueOf(zzbqe2.zzbXY.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Configured Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
            }
            zzbmd zzbmd2 = new zzbmd();
            if (!firebaseApp.zzTt()) {
                zzbmd2.zziZ(firebaseApp.getName());
            }
            zzbmd2.zzf(firebaseApp);
            zzbXN.put(firebaseApp.getName(), new FirebaseDatabase(firebaseApp, zzbqe2.zzbXP, zzbmd2));
        }
        return zzbXN.get(firebaseApp.getName());
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzbmm zzbmm2, zzbmd zzbmd2) {
        this.zzbXO = firebaseApp;
        this.zzbXP = zzbmm2;
        this.zzbXQ = zzbmd2;
    }

    public FirebaseApp getApp() {
        return this.zzbXO;
    }

    public DatabaseReference getReference() {
        this.zzUX();
        return new DatabaseReference(this.zzbXR, zzbmj.zzXf());
    }

    public DatabaseReference getReference(String string) {
        this.zzUX();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzbqh.zzjn(string);
        zzbmj zzbmj2 = new zzbmj(string);
        return new DatabaseReference(this.zzbXR, zzbmj2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzUX();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzbqe zzbqe2 = zzbqg.zzjh(string);
        if (!zzbqe2.zzbXP.zzbZA.equals(this.zzbXR.zzXo().zzbZA)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzbXR, zzbqe2.zzbXY);
    }

    public void purgeOutstandingWrites() {
        this.zzUX();
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.zzbXR.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzUX();
        zzbmn.zzl(this.zzbXR);
    }

    public void goOffline() {
        this.zzUX();
        zzbmn.zzk(this.zzbXR);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zziF("setLogLevel");
        this.zzbXQ.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zziF("setPersistenceEnabled");
        this.zzbXQ.setPersistenceEnabled(bl);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zziF(String string) {
        if (this.zzbXR != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzUX() {
        if (this.zzbXR == null) {
            this.zzbXR = zzbmn.zza(this.zzbXQ, this.zzbXP, this);
        }
    }
}

