/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Base64;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpk;
import com.google.android.gms.internal.zzbtb;
import com.google.android.gms.internal.zzbtc;
import com.google.android.gms.internal.zzbtf;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class zzbte {
    private static final char[] zzckM = "0123456789abcdef".toCharArray();

    public static zzbtc zzjg(String string) throws DatabaseException {
        String string2 = string;
        try {
            Object object;
            CharSequence charSequence;
            String[] stringArray;
            int n = string2.indexOf("//");
            if (n == -1) {
                throw new URISyntaxException(string2, "Invalid scheme specified");
            }
            int n2 = string2.substring(n + 2).indexOf("/");
            if (n2 != -1) {
                stringArray = string2.substring(n2 += n + 2).split("/");
                charSequence = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("")) continue;
                    ((StringBuilder)charSequence).append("/");
                    ((StringBuilder)charSequence).append(URLEncoder.encode(stringArray[i], "UTF-8"));
                }
                String string3 = String.valueOf(string2.substring(0, n2));
                String string4 = String.valueOf(((StringBuilder)charSequence).toString());
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            stringArray = new URI(string2);
            charSequence = stringArray.getPath().replace("+", " ");
            zzbtf.zzjm((String)charSequence);
            zzbph zzbph2 = new zzbph((String)charSequence);
            String string5 = stringArray.getScheme();
            zzbpk zzbpk2 = new zzbpk();
            zzbpk2.zzcbM = stringArray.getHost().toLowerCase();
            int n3 = stringArray.getPort();
            if (n3 != -1) {
                zzbpk2.zzcbN = string5.equals("https");
                object = String.valueOf(zzbpk2.zzcbM);
                zzbpk2.zzcbM = new StringBuilder(12 + String.valueOf(object).length()).append((String)object).append(":").append(n3).toString();
            } else {
                zzbpk2.zzcbN = true;
            }
            object = zzbpk2.zzcbM.split("\\.");
            zzbpk2.zzaGP = object[0].toLowerCase();
            zzbpk2.zzcfy = zzbpk2.zzcbM;
            zzbtc zzbtc2 = new zzbtc();
            zzbtc2.zzcak = zzbph2;
            zzbtc2.zzcab = zzbpk2;
            return zzbtc2;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DatabaseException("Invalid Firebase Database url specified", uRISyntaxException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DatabaseException("Failed to URLEncode the path", unsupportedEncodingException);
        }
    }

    public static String zzjh(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            return Base64.encodeToString((byte[])byArray, (int)2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Missing SHA-1 MessageDigest provider.", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding is required for Firebase Database to run!");
        }
    }

    public static String zzji(String string) {
        String string2 = string;
        if (string.indexOf(92) != -1) {
            string2 = string2.replace("\\", "\\\\");
        }
        if (string.indexOf(34) != -1) {
            string2 = string2.replace("\"", "\\\"");
        }
        String string3 = string2;
        return new StringBuilder(2 + String.valueOf(string3).length()).append("\"").append(string3).append("\"").toString();
    }

    public static String zzl(double d) {
        StringBuilder stringBuilder = new StringBuilder(16);
        long l = Double.doubleToLongBits(d);
        for (int i = 7; i >= 0; --i) {
            int n = (int)(l >>> 8 * i & 0xFFL);
            int n2 = n >> 4 & 0xF;
            int n3 = n & 0xF;
            stringBuilder.append(zzckM[n2]);
            stringBuilder.append(zzckM[n3]);
        }
        return stringBuilder.toString();
    }

    public static Integer zzjj(String string) {
        if (string.length() > 11 || string.length() == 0) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                return null;
            }
            bl = true;
            n = 1;
        }
        long l = 0L;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return null;
            }
            l = l * 10L + (long)(c - 48);
            ++n;
        }
        if (bl) {
            if (-l < Integer.MIN_VALUE) {
                return null;
            }
            return (int)(-l);
        }
        if (l > Integer.MAX_VALUE) {
            return null;
        }
        return (int)l;
    }

    public static int zzH(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    public static int zzl(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public static void zzbb(boolean bl) {
        zzbte.zzb(bl, "");
    }

    public static void zzb(boolean bl, String string) {
        if (!bl) {
            String string2 = String.valueOf(string);
            throw new AssertionError((Object)(string2.length() != 0 ? "hardAssert failed: ".concat(string2) : new String("hardAssert failed: ")));
        }
    }

    public static zzbtb<Task<Void>, DatabaseReference.CompletionListener> zzb(DatabaseReference.CompletionListener completionListener) {
        if (completionListener == null) {
            final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            DatabaseReference.CompletionListener completionListener2 = new DatabaseReference.CompletionListener(){

                @Override
                public void onComplete(DatabaseError databaseError, DatabaseReference databaseReference) {
                    if (databaseError != null) {
                        taskCompletionSource.setException((Exception)databaseError.toException());
                    } else {
                        taskCompletionSource.setResult(null);
                    }
                }
            };
            return new zzbtb<Task<Void>, DatabaseReference.CompletionListener>(taskCompletionSource.getTask(), completionListener2);
        }
        return new zzbtb<Object, DatabaseReference.CompletionListener>(null, completionListener);
    }
}

