/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzbpb;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbpk;
import com.google.android.gms.internal.zzbpl;
import com.google.android.gms.internal.zzbtc;
import com.google.android.gms.internal.zzbte;
import com.google.android.gms.internal.zzbtf;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzbpk, FirebaseDatabase>> zzbZZ = new HashMap<String, Map<zzbpk, FirebaseDatabase>>();
    private final FirebaseApp zzcaa;
    private final zzbpk zzcab;
    private final zzbpb zzcac;
    private zzbpj zzcad;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzbpk, FirebaseDatabase> map = zzbZZ.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzbpk, FirebaseDatabase>();
            zzbZZ.put(firebaseApp.getName(), map);
        }
        zzbtc zzbtc2 = zzbte.zzjg(string);
        if (!zzbtc2.zzcak.isEmpty()) {
            String string2 = String.valueOf(zzbtc2.zzcak.toString());
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzbtc2.zzcab);
        if (firebaseDatabase == null) {
            zzbpb zzbpb2 = new zzbpb();
            if (!firebaseApp.zzUU()) {
                zzbpb2.zziY(firebaseApp.getName());
            }
            zzbpb2.zzf(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzbtc2.zzcab, zzbpb2);
            map.put(zzbtc2.zzcab, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzbpk zzbpk2, zzbpb zzbpb2) {
        this.zzcaa = firebaseApp;
        this.zzcab = zzbpk2;
        this.zzcac = zzbpb2;
    }

    public FirebaseApp getApp() {
        return this.zzcaa;
    }

    public DatabaseReference getReference() {
        this.zzWG();
        return new DatabaseReference(this.zzcad, zzbph.zzYO());
    }

    public DatabaseReference getReference(String string) {
        this.zzWG();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzbtf.zzjm(string);
        zzbph zzbph2 = new zzbph(string);
        return new DatabaseReference(this.zzcad, zzbph2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzWG();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzbtc zzbtc2 = zzbte.zzjg(string);
        if (!zzbtc2.zzcab.zzcbM.equals(this.zzcad.zzYX().zzcbM)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzcad, zzbtc2.zzcak);
    }

    public void purgeOutstandingWrites() {
        this.zzWG();
        this.zzcad.zzs(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.zzcad.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzWG();
        zzbpl.zzl(this.zzcad);
    }

    public void goOffline() {
        this.zzWG();
        zzbpl.zzk(this.zzcad);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zziE("setLogLevel");
        this.zzcac.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zziE("setPersistenceEnabled");
        this.zzcac.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zziE("setPersistenceCacheSizeBytes");
        this.zzcac.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zziE(String string) {
        if (this.zzcad != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzWG() {
        if (this.zzcad == null) {
            this.zzcad = zzbpl.zza(this.zzcac, this.zzcab, this);
        }
    }
}

