/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.aam;
import com.google.android.gms.internal.aao;
import com.google.android.gms.internal.abe;
import com.google.android.gms.internal.abi;
import com.google.android.gms.internal.abk;
import com.google.android.gms.internal.abw;
import com.google.android.gms.internal.acd;
import com.google.android.gms.internal.ace;
import com.google.android.gms.internal.ach;
import com.google.android.gms.internal.adh;
import com.google.android.gms.internal.ado;
import com.google.android.gms.internal.adq;
import com.google.android.gms.internal.adt;
import com.google.android.gms.internal.sa;
import com.google.android.gms.internal.sb;
import com.google.android.gms.internal.sc;
import com.google.android.gms.internal.uw;
import com.google.android.gms.internal.va;
import com.google.android.gms.internal.vn;
import com.google.android.gms.internal.yi;
import com.google.android.gms.internal.ze;
import com.google.android.gms.internal.zf;
import com.google.android.gms.internal.zj;
import com.google.android.gms.internal.zr;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class rz
implements ze {
    private static final Charset zzayv = Charset.forName("UTF-8");
    private final SQLiteDatabase zzccF;
    private final abe zzccG;
    private boolean zzccH;
    private long zzccI = 0L;

    public rz(Context context, va va2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzccG = va2.zzho("Persistence");
        this.zzccF = rz.zzO(context, string2);
    }

    @Override
    public final void zza(vn vn2, ace ace2, long l) {
        this.zzFN();
        long l2 = System.currentTimeMillis();
        byte[] byArray = rz.zzW(ace2.getValue(true));
        this.zza(vn2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final void zza(vn vn2, uw uw2, long l) {
        this.zzFN();
        long l2 = System.currentTimeMillis();
        byte[] byArray = rz.zzW(uw2.zzaD(true));
        this.zza(vn2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final void zzal(long l) {
        this.zzFN();
        long l2 = System.currentTimeMillis();
        int n = this.zzccF.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final List<yi> zzFJ() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<yi> arrayList = new ArrayList<yi>();
        try (Cursor cursor = this.zzccF.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<yi> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                yi yi2;
                Iterable<acd> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new vn(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = rz.zzR(arrayList3);
                }
                Object object = adh.zzhv((String)new String(byArray, zzayv));
                if ("o".equals(string)) {
                    iterable = ach.zza(object, abw.zzJr());
                    yi2 = new yi(l2, (vn)((Object)arrayList2), (ace)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = uw.zzD((Map)object);
                    yi2 = new yi(l2, (vn)((Object)arrayList2), (uw)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(yi2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzccG.zzIX()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzccG.zzc(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(vn vn2, long l, String string, byte[] byArray) {
        this.zzFN();
        this.zzccF.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = rz.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", rz.zzc(vn2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzccF.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", rz.zzc(vn2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzccF.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final ace zza(vn vn2) {
        return this.zzb(vn2);
    }

    @Override
    public final void zza(vn vn2, ace ace2) {
        this.zzFN();
        this.zza(vn2, ace2, false);
    }

    @Override
    public final void zzb(vn vn2, ace ace2) {
        this.zzFN();
        this.zza(vn2, ace2, true);
    }

    private final void zza(vn vn2, ace ace2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", vn2);
            n = this.zzc(vn2, ace2);
        } else {
            n2 = 0;
            n = 0;
            for (acd acd2 : ace2) {
                n2 += this.zza("serverCache", vn2.zza(acd2.zzJA()));
                n += this.zzc(vn2.zza(acd2.zzJA()), acd2.zzFE());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, vn2.toString(), l2);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final void zza(vn vn2, uw uw2) {
        this.zzFN();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<vn, ace> entry : uw2) {
            n2 += this.zza("serverCache", vn2.zzh(entry.getKey()));
            n += this.zzc(vn2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, vn2.toString(), l2);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final long zzFK() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzccF.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zj zj2) {
        this.zzFN();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zj2.id));
        contentValues.put("path", rz.zzc(zj2.zzcjg.zzFH()));
        contentValues.put("queryParams", zj2.zzcjg.zzIK().zzII());
        contentValues.put("lastUse", Long.valueOf(zj2.zzcjh));
        contentValues.put("complete", Boolean.valueOf(zj2.complete));
        contentValues.put("active", Boolean.valueOf(zj2.zzbpj));
        this.zzccF.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final void zzam(long l) {
        this.zzFN();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzccF.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzccF.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zj> zzFL() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zj> arrayList = new ArrayList<zj>();
        try (Cursor cursor = this.zzccF.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zj> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new vn(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = adh.zzhu((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zj> arrayList3 = arrayList2;
                objectArray = aam.zzF((Map<String, Object>)object);
                aao aao2 = new aao((vn)((Object)arrayList3), (aam)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zj zj2 = new zj(l2, aao2, l3, bl, bl2);
                arrayList.add(zj2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzccG.zzIX()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzccG.zzc((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzan(long l) {
        this.zzFN();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzccF.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzccG.zzc(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<abi> set) {
        this.zzFN();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzccF.delete("trackedKeys", string2, new String[]{string});
        for (abi abi2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", abi2.asString());
            this.zzccF.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzccG.zzc(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<abi> set, Set<abi> set2) {
        this.zzFN();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (abi abi2 : set2) {
            this.zzccF.delete("trackedKeys", string, new String[]{string2, abi2.asString()});
        }
        for (abi abi2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", abi2.asString());
            this.zzccF.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzccG.zzc(string3, null, objectArray);
        }
    }

    @Override
    public final Set<abi> zzao(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<abi> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(rz.zzj(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzccF.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(abi.zzhs(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzccG.zzIX()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzccG.zzc(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(vn vn2, zf zf2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<abi> iterable2;
        if (!zf2.zzIe()) {
            return;
        }
        this.zzFN();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(vn2, new String[]{"rowid", "path"});
        zr<Object> zr2 = new zr<Object>(null);
        zr<Object> zr3 = new zr<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new vn(cursor.getString(1));
            if (!vn2.zzi((vn)iterable2)) {
                iterable = String.valueOf(vn2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzccG.zze(string2, null);
                continue;
            }
            iterable = vn.zza(vn2, (vn)iterable2);
            if (zf2.zzv((vn)iterable)) {
                zr2 = zr2.zzb((vn)iterable, l2);
                continue;
            }
            if (zf2.zzw((vn)iterable)) {
                zr3 = zr3.zzb((vn)iterable, l2);
                continue;
            }
            string3 = String.valueOf(vn2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzccG.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zr2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(vn2, vn.zzHq(), zr2, zr3, zf2, (List<adq<vn, ace>>)iterable2);
            iterable = zr2.values();
            string = String.valueOf(rz.zzj(iterable));
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzccF.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                adq adq2 = (adq)e;
                this.zzc(vn2.zzh((vn)adq2.getFirst()), (ace)adq2.zzJV());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzccG.zzc(string2, null, objectArray);
        }
    }

    private final void zza(vn vn2, vn vn3, zr<Long> zr2, zr<Long> zr3, zf zf2, List<adq<vn, ace>> list) {
        if (zr2.getValue() != null) {
            int n = zf2.zza(0, new sa(this, zr3));
            if (n > 0) {
                vn vn4 = vn2.zzh(vn3);
                if (this.zzccG.zzIX()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, vn4);
                    this.zzccG.zzc(string, null, objectArray);
                }
                ace ace2 = this.zzb(vn4);
                zf2.zza(null, new sb(this, zr3, list, vn3, ace2));
            }
            return;
        }
        for (Map.Entry<abi, zr<Long>> entry : zr2.zzIj()) {
            abi abi2 = entry.getKey();
            zf zf3 = zf2.zzd(entry.getKey());
            this.zza(vn2, vn3.zza(abi2), entry.getValue(), zr3.zze(abi2), zf3, list);
        }
    }

    @Override
    public final void zzFM() {
        this.zzFN();
        long l = System.currentTimeMillis();
        int n = this.zzccF.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        adt.zzb(!this.zzccH, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzccG.zzc("Starting transaction.", null, objectArray);
        }
        this.zzccF.beginTransaction();
        this.zzccH = true;
        this.zzccI = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzccF.endTransaction();
        this.zzccH = false;
        long l = System.currentTimeMillis() - this.zzccI;
        if (this.zzccG.zzIX()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzccG.zzc(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzccF.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzO(Context context, String string) {
        sc sc2 = new sc(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = sc2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzFN() {
        adt.zzb(this.zzccH, "Transaction expected to already be in progress.");
    }

    private final int zzc(vn vn2, ace ace2) {
        long l = ado.zzn(ace2);
        if (ace2 instanceof abk && l > 16384L) {
            if (this.zzccG.zzIX()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", vn2, l, 16384);
                this.zzccG.zzc(string, null, objectArray);
            }
            int n = 0;
            for (acd acd2 : ace2) {
                n += this.zzc(vn2.zza(acd2.zzJA()), acd2.zzFE());
            }
            if (!ace2.zzJh().isEmpty()) {
                this.zzd(vn2.zza(abi.zzJb()), ace2.zzJh());
                ++n;
            }
            this.zzd(vn2, abw.zzJr());
            return ++n;
        }
        this.zzd(vn2, ace2);
        return 1;
    }

    private static String zza(vn vn2, int n) {
        String string = String.valueOf(rz.zzc(vn2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(vn vn2, ace ace2) {
        byte[] byArray = rz.zzW(ace2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = rz.zzd(byArray, 262144);
            if (this.zzccG.zzIX()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzccG.zzc(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", rz.zza(vn2, n));
                contentValues.put("value", list.get(n));
                this.zzccF.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", rz.zzc(vn2));
        contentValues.put("value", byArray);
        this.zzccF.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final ace zzb(vn vn2) {
        String string;
        Object[] objectArray;
        vn vn3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(vn2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        ace ace2 = abw.zzJr();
        boolean bl = false;
        HashMap<vn, void> hashMap = new HashMap<vn, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                vn3 = new vn(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = rz.zza(vn3, arrayList, i);
                if (this.zzccG.zzIX()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzccG.zzc(string, null, objectArray);
                }
                ace ace3 = rz.zzC(rz.zzR(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                ace ace4 = rz.zzC((byte[])arrayList2.get(i));
                vn3 = new vn((String)arrayList.get(i));
            }
            if (vn3.zzHw() != null && vn3.zzHw().zzJd()) {
                hashMap.put(vn3, object);
                continue;
            }
            if (vn3.zzi(vn2)) {
                adt.zzb(!bl, "Descendants of path must come after ancestors.");
                ace2 = object.zzN(vn.zza(vn3, vn2));
                continue;
            }
            if (vn2.zzi(vn3)) {
                bl = true;
                object2 = vn.zza(vn2, vn3);
                ace2 = ace2.zzl((vn)object2, (ace)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", vn3, vn2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            vn3 = (vn)entry.getKey();
            ace2 = ace2.zzl(vn.zza(vn2, vn3), (ace)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzccG.zzIX()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), ado.zzo(ace2), vn2, l7, l2, l4, l6);
            this.zzccG.zzc(string, null, objectArray);
        }
        return ace2;
    }

    private static int zza(vn vn2, List<String> list, int n) {
        int n2;
        String string = rz.zzc(vn2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(rz.zza(vn2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(vn vn2, String[] stringArray) {
        String[] stringArray2;
        String string = rz.zzc(vn2);
        String string2 = rz.zzhb(string);
        String[] stringArray3 = stringArray2 = new String[vn2.size() + 3];
        vn vn3 = vn2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!vn3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = rz.zzc(vn3);
            vn3 = vn3.zzHv();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = rz.zzc(vn.zzHq());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[vn2.size() + 1] = string;
        stringArray2[vn2.size() + 2] = string2;
        String string6 = "path";
        return this.zzccF.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(vn vn2) {
        if (vn2.isEmpty()) {
            return "/";
        }
        return String.valueOf(vn2.toString()).concat("/");
    }

    private static String zzhb(String string) {
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, vn vn2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = rz.zzc(vn2);
        String string4 = rz.zzhb(string3);
        return this.zzccF.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzR(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzW(Object object) {
        try {
            return adh.zzak((Object)object).getBytes(zzayv);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static ace zzC(byte[] byArray) {
        try {
            return ach.zza(adh.zzhv((String)new String(byArray, zzayv)), abw.zzJr());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzayv);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzj(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

