/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.adr;
import com.google.android.gms.internal.adt;
import com.google.android.gms.internal.adv;
import com.google.android.gms.internal.vd;
import com.google.android.gms.internal.vn;
import com.google.android.gms.internal.vq;
import com.google.android.gms.internal.wt;
import com.google.android.gms.internal.wu;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<wt, FirebaseDatabase>> zzcbR = new HashMap<String, Map<wt, FirebaseDatabase>>();
    private final FirebaseApp zzcbS;
    private final wt zzcbT;
    private final vd zzcbU;
    private vq zzcbV;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<wt, FirebaseDatabase> map = zzcbR.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<wt, FirebaseDatabase>();
            zzcbR.put(firebaseApp.getName(), map);
        }
        adr adr2 = adt.zzhw(string);
        if (!adr2.zzcch.isEmpty()) {
            String string2 = String.valueOf(adr2.zzcch.toString());
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(adr2.zzcbT);
        if (firebaseDatabase == null) {
            vd vd2 = new vd();
            if (!firebaseApp.zzEs()) {
                vd2.zzhq(firebaseApp.getName());
            }
            vd2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, adr2.zzcbT, vd2);
            map.put(adr2.zzcbT, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, wt wt2, vd vd2) {
        this.zzcbS = firebaseApp;
        this.zzcbT = wt2;
        this.zzcbU = vd2;
    }

    public FirebaseApp getApp() {
        return this.zzcbS;
    }

    public DatabaseReference getReference() {
        this.zzFD();
        return new DatabaseReference(this.zzcbV, vn.zzHq());
    }

    public DatabaseReference getReference(String string) {
        this.zzFD();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        adv.zzhB(string);
        vn vn2 = new vn(string);
        return new DatabaseReference(this.zzcbV, vn2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzFD();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        adr adr2 = adt.zzhw(string);
        if (!adr2.zzcbT.host.equals(this.zzcbV.zzHy().host)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzcbV, adr2.zzcch);
    }

    public void purgeOutstandingWrites() {
        this.zzFD();
        this.zzcbV.zzq(new zzg(this));
    }

    public void goOnline() {
        this.zzFD();
        wu.zzl(this.zzcbV);
    }

    public void goOffline() {
        this.zzFD();
        wu.zzk(this.zzcbV);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzha("setLogLevel");
        this.zzcbU.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzha("setPersistenceEnabled");
        this.zzcbU.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzha("setPersistenceCacheSizeBytes");
        this.zzcbU.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzha(String string) {
        if (this.zzcbV != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzFD() {
        if (this.zzcbV == null) {
            this.zzcbV = wu.zza(this.zzcbU, this.zzcbT, this);
        }
    }

    static /* synthetic */ vq zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzcbV;
    }
}

