/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.nb;
import com.google.android.gms.internal.nc;
import com.google.android.gms.internal.nd;
import com.google.android.gms.internal.px;
import com.google.android.gms.internal.qb;
import com.google.android.gms.internal.qo;
import com.google.android.gms.internal.tj;
import com.google.android.gms.internal.uf;
import com.google.android.gms.internal.ug;
import com.google.android.gms.internal.uk;
import com.google.android.gms.internal.us;
import com.google.android.gms.internal.vn;
import com.google.android.gms.internal.vp;
import com.google.android.gms.internal.wf;
import com.google.android.gms.internal.wj;
import com.google.android.gms.internal.wl;
import com.google.android.gms.internal.wx;
import com.google.android.gms.internal.xe;
import com.google.android.gms.internal.xf;
import com.google.android.gms.internal.xi;
import com.google.android.gms.internal.yi;
import com.google.android.gms.internal.yp;
import com.google.android.gms.internal.yr;
import com.google.android.gms.internal.yu;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class na
implements uf {
    private static final Charset zzayt = Charset.forName("UTF-8");
    private final SQLiteDatabase zzbZG;
    private final wf zzbZH;
    private boolean zzbZI;
    private long zzbZJ = 0L;

    public na(Context context, qb qb2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzbZH = qb2.zzgP("Persistence");
        this.zzbZG = na.zzN(context, string2);
    }

    @Override
    public final void zza(qo qo2, xf xf2, long l) {
        this.zzFv();
        long l2 = System.currentTimeMillis();
        byte[] byArray = na.zzW(xf2.getValue(true));
        this.zza(qo2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(qo qo2, px px2, long l) {
        this.zzFv();
        long l2 = System.currentTimeMillis();
        byte[] byArray = na.zzW(px2.zzaD(true));
        this.zza(qo2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzal(long l) {
        this.zzFv();
        long l2 = System.currentTimeMillis();
        int n = this.zzbZG.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<tj> zzFr() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<tj> arrayList = new ArrayList<tj>();
        try (Cursor cursor = this.zzbZG.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<tj> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                tj tj2;
                Iterable<xe> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new qo(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = na.zzQ(arrayList3);
                }
                Object object = yi.zzgW((String)new String(byArray, zzayt));
                if ("o".equals(string)) {
                    iterable = xi.zza(object, wx.zzIZ());
                    tj2 = new tj(l2, (qo)((Object)arrayList2), (xf)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = px.zzD((Map)object);
                    tj2 = new tj(l2, (qo)((Object)arrayList2), (px)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(tj2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbZH.zzIF()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzbZH.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(qo qo2, long l, String string, byte[] byArray) {
        this.zzFv();
        this.zzbZG.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = na.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", na.zzc(qo2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzbZG.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", na.zzc(qo2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzbZG.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final xf zza(qo qo2) {
        return this.zzb(qo2);
    }

    @Override
    public final void zza(qo qo2, xf xf2) {
        this.zzFv();
        this.zza(qo2, xf2, false);
    }

    @Override
    public final void zzb(qo qo2, xf xf2) {
        this.zzFv();
        this.zza(qo2, xf2, true);
    }

    private final void zza(qo qo2, xf xf2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", qo2);
            n = this.zzc(qo2, xf2);
        } else {
            n2 = 0;
            n = 0;
            for (xe xe2 : xf2) {
                n2 += this.zza("serverCache", qo2.zza(xe2.zzJi()));
                n += this.zzc(qo2.zza(xe2.zzJi()), xe2.zzFm());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, qo2.toString(), l2);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(qo qo2, px px2) {
        this.zzFv();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<qo, xf> entry : px2) {
            n2 += this.zza("serverCache", qo2.zzh(entry.getKey()));
            n += this.zzc(qo2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, qo2.toString(), l2);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzFs() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzbZG.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(uk uk2) {
        this.zzFv();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(uk2.id));
        contentValues.put("path", na.zzc(uk2.zzcgi.zzFp()));
        contentValues.put("queryParams", uk2.zzcgi.zzIs().zzIq());
        contentValues.put("lastUse", Long.valueOf(uk2.zzcgj));
        contentValues.put("complete", Boolean.valueOf(uk2.complete));
        contentValues.put("active", Boolean.valueOf(uk2.zzbpf));
        this.zzbZG.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzam(long l) {
        this.zzFv();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbZG.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzbZG.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<uk> zzFt() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<uk> arrayList = new ArrayList<uk>();
        try (Cursor cursor = this.zzbZG.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<uk> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new qo(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = yi.zzgV((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<uk> arrayList3 = arrayList2;
                objectArray = vn.zzF((Map<String, Object>)object);
                vp vp2 = new vp((qo)((Object)arrayList3), (vn)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                uk uk2 = new uk(l2, vp2, l3, bl, bl2);
                arrayList.add(uk2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbZH.zzIF()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzbZH.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzan(long l) {
        this.zzFv();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzbZG.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzbZH.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<wj> set) {
        this.zzFv();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbZG.delete("trackedKeys", string2, new String[]{string});
        for (wj wj2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", wj2.asString());
            this.zzbZG.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzbZH.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<wj> set, Set<wj> set2) {
        this.zzFv();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (wj wj2 : set2) {
            this.zzbZG.delete("trackedKeys", string, new String[]{string2, wj2.asString()});
        }
        for (wj wj2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", wj2.asString());
            this.zzbZG.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzbZH.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<wj> zzao(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<wj> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(na.zzj(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzbZG.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(wj.zzgT(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzbZH.zzIF()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzbZH.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(qo qo2, ug ug2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<wj> iterable2;
        if (!ug2.zzHM()) {
            return;
        }
        this.zzFv();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(qo2, new String[]{"rowid", "path"});
        us<Object> us2 = new us<Object>(null);
        us<Object> us3 = new us<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new qo(cursor.getString(1));
            if (!qo2.zzi((qo)iterable2)) {
                iterable = String.valueOf(qo2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzbZH.zze(string2, null);
                continue;
            }
            iterable = qo.zza(qo2, (qo)iterable2);
            if (ug2.zzv((qo)iterable)) {
                us2 = us2.zzb((qo)iterable, l2);
                continue;
            }
            if (ug2.zzw((qo)iterable)) {
                us3 = us3.zzb((qo)iterable, l2);
                continue;
            }
            string3 = String.valueOf(qo2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzbZH.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!us2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(qo2, qo.zzGY(), us2, us3, ug2, (List<yr<qo, xf>>)iterable2);
            iterable = us2.values();
            string = String.valueOf(na.zzj(iterable));
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzbZG.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                yr yr2 = (yr)e;
                this.zzc(qo2.zzh((qo)yr2.getFirst()), (xf)yr2.zzJD());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzbZH.zzb(string2, null, objectArray);
        }
    }

    private final void zza(qo qo2, qo qo3, us<Long> us2, us<Long> us3, ug ug2, List<yr<qo, xf>> list) {
        if (us2.getValue() != null) {
            int n = ug2.zza(0, new nb(this, us3));
            if (n > 0) {
                qo qo4 = qo2.zzh(qo3);
                if (this.zzbZH.zzIF()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, qo4);
                    this.zzbZH.zzb(string, null, objectArray);
                }
                xf xf2 = this.zzb(qo4);
                ug2.zza(null, new nc(this, us3, list, qo3, xf2));
            }
            return;
        }
        for (Map.Entry<wj, us<Long>> entry : us2.zzHR()) {
            wj wj2 = entry.getKey();
            ug ug3 = ug2.zzd(entry.getKey());
            this.zza(qo2, qo3.zza(wj2), entry.getValue(), us3.zze(wj2), ug3, list);
        }
    }

    @Override
    public final void zzFu() {
        this.zzFv();
        long l = System.currentTimeMillis();
        int n = this.zzbZG.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        yu.zzb(!this.zzbZI, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzbZH.zzb("Starting transaction.", null, objectArray);
        }
        this.zzbZG.beginTransaction();
        this.zzbZI = true;
        this.zzbZJ = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzbZG.endTransaction();
        this.zzbZI = false;
        long l = System.currentTimeMillis() - this.zzbZJ;
        if (this.zzbZH.zzIF()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzbZH.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzbZG.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzN(Context context, String string) {
        nd nd2 = new nd(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = nd2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzFv() {
        yu.zzb(this.zzbZI, "Transaction expected to already be in progress.");
    }

    private final int zzc(qo qo2, xf xf2) {
        long l = yp.zzn(xf2);
        if (xf2 instanceof wl && l > 16384L) {
            if (this.zzbZH.zzIF()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", qo2, l, 16384);
                this.zzbZH.zzb(string, null, objectArray);
            }
            int n = 0;
            for (xe xe2 : xf2) {
                n += this.zzc(qo2.zza(xe2.zzJi()), xe2.zzFm());
            }
            if (!xf2.zzIP().isEmpty()) {
                this.zzd(qo2.zza(wj.zzIJ()), xf2.zzIP());
                ++n;
            }
            this.zzd(qo2, wx.zzIZ());
            return ++n;
        }
        this.zzd(qo2, xf2);
        return 1;
    }

    private static String zza(qo qo2, int n) {
        String string = String.valueOf(na.zzc(qo2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(qo qo2, xf xf2) {
        byte[] byArray = na.zzW(xf2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = na.zzd(byArray, 262144);
            if (this.zzbZH.zzIF()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzbZH.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", na.zza(qo2, n));
                contentValues.put("value", list.get(n));
                this.zzbZG.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", na.zzc(qo2));
        contentValues.put("value", byArray);
        this.zzbZG.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final xf zzb(qo qo2) {
        String string;
        Object[] objectArray;
        qo qo3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(qo2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        xf xf2 = wx.zzIZ();
        boolean bl = false;
        HashMap<qo, void> hashMap = new HashMap<qo, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                qo3 = new qo(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = na.zza(qo3, arrayList, i);
                if (this.zzbZH.zzIF()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzbZH.zzb(string, null, objectArray);
                }
                xf xf3 = na.zzB(na.zzQ(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                xf xf4 = na.zzB((byte[])arrayList2.get(i));
                qo3 = new qo((String)arrayList.get(i));
            }
            if (qo3.zzHe() != null && qo3.zzHe().zzIL()) {
                hashMap.put(qo3, object);
                continue;
            }
            if (qo3.zzi(qo2)) {
                yu.zzb(!bl, "Descendants of path must come after ancestors.");
                xf2 = object.zzN(qo.zza(qo3, qo2));
                continue;
            }
            if (qo2.zzi(qo3)) {
                bl = true;
                object2 = qo.zza(qo2, qo3);
                xf2 = xf2.zzl((qo)object2, (xf)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", qo3, qo2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            qo3 = (qo)entry.getKey();
            xf2 = xf2.zzl(qo.zza(qo2, qo3), (xf)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzbZH.zzIF()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), yp.zzo(xf2), qo2, l7, l2, l4, l6);
            this.zzbZH.zzb(string, null, objectArray);
        }
        return xf2;
    }

    private static int zza(qo qo2, List<String> list, int n) {
        int n2;
        String string = na.zzc(qo2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(na.zza(qo2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(qo qo2, String[] stringArray) {
        String[] stringArray2;
        String string = na.zzc(qo2);
        String string2 = na.zzgC(string);
        String[] stringArray3 = stringArray2 = new String[qo2.size() + 3];
        qo qo3 = qo2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!qo3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = na.zzc(qo3);
            qo3 = qo3.zzHd();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = na.zzc(qo.zzGY());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[qo2.size() + 1] = string;
        stringArray2[qo2.size() + 2] = string2;
        String string6 = "path";
        return this.zzbZG.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(qo qo2) {
        if (qo2.isEmpty()) {
            return "/";
        }
        return String.valueOf(qo2.toString()).concat("/");
    }

    private static String zzgC(String string) {
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, qo qo2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = na.zzc(qo2);
        String string4 = na.zzgC(string3);
        return this.zzbZG.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzQ(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzW(Object object) {
        try {
            return yi.zzak((Object)object).getBytes(zzayt);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static xf zzB(byte[] byArray) {
        try {
            return xi.zza(yi.zzgW((String)new String(byArray, zzayt)), wx.zzIZ());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzayt);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzj(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

