/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zzbYG = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzbYH;
    private final int code;
    private final String message;
    private final String zzbYI;

    public static DatabaseError zzgA(String string) {
        String string2 = string;
        Integer n = zzbYH.get(string2.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string3 = zzbYG.get(n);
        return new DatabaseError(n, string3, null);
    }

    public static DatabaseError zzZ(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        Integer n = zzbYH.get(string4.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string5 = string3 == null ? zzbYG.get(n) : string3;
        return new DatabaseError(n, string5, null);
    }

    public static DatabaseError zzbU(int n) {
        if (!zzbYG.containsKey(-25)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: -25").toString());
        }
        String string = zzbYG.get(-25);
        return new DatabaseError(-25, string, null);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(zzbYG.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(-11, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.code = n;
        this.message = string;
        this.zzbYI = "";
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.zzbYI;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        if (string.length() != 0) {
            return "DatabaseError: ".concat(string);
        }
        return new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zzbYG.put(-1, "The transaction needs to be run again with current data");
        zzbYG.put(-2, "The server indicated that this operation failed");
        zzbYG.put(-3, "This client does not have permission to perform this operation");
        zzbYG.put(-4, "The operation had to be aborted due to a network disconnect");
        zzbYG.put(-6, "The supplied auth token has expired");
        zzbYG.put(-7, "The supplied auth token was invalid");
        zzbYG.put(-8, "The transaction had too many retries");
        zzbYG.put(-9, "The transaction was overridden by a subsequent set");
        zzbYG.put(-10, "The service is unavailable");
        zzbYG.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zzbYG.put(-24, "The operation could not be performed due to a network error");
        zzbYG.put(-25, "The write was canceled by the user.");
        zzbYG.put(-999, "An unknown error occurred");
        zzbYH = new HashMap<String, Integer>();
        zzbYH.put("datastale", -1);
        zzbYH.put("failure", -2);
        zzbYH.put("permission_denied", -3);
        zzbYH.put("disconnected", -4);
        zzbYH.put("expired_token", -6);
        zzbYH.put("invalid_token", -7);
        zzbYH.put("maxretries", -8);
        zzbYH.put("overriddenbyset", -9);
        zzbYH.put("unavailable", -10);
        zzbYH.put("network_error", -24);
        zzbYH.put("write_canceled", -25);
    }
}

