/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.px;
import com.google.android.gms.internal.qe;
import com.google.android.gms.internal.qo;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.rv;
import com.google.android.gms.internal.tk;
import com.google.android.gms.internal.wj;
import com.google.android.gms.internal.xf;
import com.google.android.gms.internal.xi;
import com.google.android.gms.internal.xl;
import com.google.android.gms.internal.yr;
import com.google.android.gms.internal.yt;
import com.google.android.gms.internal.yu;
import com.google.android.gms.internal.yw;
import com.google.android.gms.internal.yx;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static qe zzbYJ;

    DatabaseReference(qr qr2, qo qo2) {
        super(qr2, qo2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzbZi.isEmpty()) {
            yw.zzhc(string);
        } else {
            yw.zzhb(string);
        }
        qo qo2 = this.zzbZi.zzh(new qo(string));
        return new DatabaseReference(this.zzbYW, qo2);
    }

    public DatabaseReference push() {
        wj wj2 = wj.zzgT(yt.zzaz(this.zzbYW.zzHh()));
        return new DatabaseReference(this.zzbYW, this.zzbZi.zza(wj2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, xl.zzc(this.zzbZi, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, xl.zzc(this.zzbZi, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, xl.zzc(this.zzbZi, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, xl.zzc(this.zzbZi, object2), completionListener);
    }

    private final Task<Void> zza(Object object, xf xf2, CompletionListener completionListener) {
        yw.zzO(this.zzbZi);
        tk.zza(this.zzbZi, object);
        Object object2 = yx.zzan(object);
        yw.zzam(object2);
        xf xf3 = xi.zza(object2, xf2);
        yr<Task<Void>, CompletionListener> yr2 = yu.zzb(completionListener);
        this.zzbYW.zzq(new zzc(this, xf3, yr2));
        return yr2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(xl.zzc(this.zzbZi, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(xl.zzc(this.zzbZi, object), completionListener);
    }

    private final Task<Void> zza(xf xf2, CompletionListener completionListener) {
        yw.zzO(this.zzbZi);
        yr<Task<Void>, CompletionListener> yr2 = yu.zzb(completionListener);
        this.zzbYW.zzq(new zzd(this, xf2, yr2));
        return yr2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = yx.zzG(map);
        px px2 = px.zzE(yw.zzb(this.zzbZi, map2));
        yr<Task<Void>, CompletionListener> yr2 = yu.zzb(completionListener);
        this.zzbYW.zzq(new zze(this, px2, yr2, map2));
        return yr2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        yw.zzO(this.zzbZi);
        return new OnDisconnect(this.zzbYW, this.zzbZi);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        yw.zzO(this.zzbZi);
        this.zzbYW.zzq(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        rv.zzd(DatabaseReference.zzFk());
    }

    public static void goOnline() {
        rv.zze(DatabaseReference.zzFk());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzbYW.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzbYW.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        qo qo2 = this.zzbZi.zzHd();
        if (qo2 != null) {
            return new DatabaseReference(this.zzbYW, qo2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzbYW, new qo(""));
    }

    public String getKey() {
        if (this.zzbZi.isEmpty()) {
            return null;
        }
        return this.zzbZi.zzHe().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized qe zzFk() {
        if (zzbYJ == null) {
            zzbYJ = new qe();
        }
        return zzbYJ;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

