/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.pw;
import com.google.android.gms.internal.qf;
import com.google.android.gms.internal.qo;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.tl;
import com.google.android.gms.internal.tq;
import com.google.android.gms.internal.vn;
import com.google.android.gms.internal.vp;
import com.google.android.gms.internal.wi;
import com.google.android.gms.internal.wj;
import com.google.android.gms.internal.ww;
import com.google.android.gms.internal.wx;
import com.google.android.gms.internal.xa;
import com.google.android.gms.internal.xf;
import com.google.android.gms.internal.xj;
import com.google.android.gms.internal.xk;
import com.google.android.gms.internal.xl;
import com.google.android.gms.internal.xn;
import com.google.android.gms.internal.xo;
import com.google.android.gms.internal.yu;
import com.google.android.gms.internal.yw;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final qr zzbYW;
    protected final qo zzbZi;
    private vn zzbZm;
    private final boolean zzbZn;

    private Query(qr qr2, qo qo2, vn vn2, boolean bl) throws DatabaseException {
        this.zzbYW = qr2;
        this.zzbZi = qo2;
        this.zzbZm = vn2;
        this.zzbZn = bl;
        vn vn3 = vn2;
        yu.zzb(!vn3.zzId() || !vn3.zzIg() || !vn3.zzIj() || vn3.zzIk(), "Validation of queries failed.");
    }

    Query(qr qr2, qo qo2) {
        this.zzbYW = qr2;
        this.zzbZi = qo2;
        this.zzbZm = vn.zzcgZ;
        this.zzbZn = false;
    }

    private static void zza(vn vn2) {
        if (vn2.zzIl().equals(xa.zzJf())) {
            xf xf2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (vn2.zzId()) {
                xf2 = vn2.zzIe();
                if (vn2.zzIf() != wj.zzIH() || !(xf2 instanceof xn)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (vn2.zzIg()) {
                xf2 = vn2.zzIh();
                if (vn2.zzIi() != wj.zzII() || !(xf2 instanceof xn)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (vn2.zzIl().equals(xk.zzJj()) && (vn2.zzId() && !xl.zzl(vn2.zzIe()) || vn2.zzIg() && !xl.zzl(vn2.zzIh()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(vn vn2) {
        if (vn2.zzId() && vn2.zzIg() && vn2.zzIj() && !vn2.zzIk()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzFn() {
        if (this.zzbZm.zzId()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzbZm.zzIg()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzFo() {
        if (this.zzbZn) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new tl(this.zzbYW, valueEventListener, this.zzFq()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new pw(this.zzbYW, childEventListener, this.zzFq()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new tl(this.zzbYW, new zzp(this, valueEventListener), this.zzFq()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new tl(this.zzbYW, valueEventListener, this.zzFq()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new pw(this.zzbYW, childEventListener, this.zzFq()));
    }

    private final void zza(qf qf2) {
        tq.zzHz().zzj(qf2);
        this.zzbYW.zzq(new zzq(this, qf2));
    }

    private final void zzb(qf qf2) {
        tq.zzHz().zzi(qf2);
        this.zzbYW.zzq(new zzr(this, qf2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzbZi.isEmpty() && this.zzbZi.zzHb().equals(wj.zzIK())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzbYW.zzq(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        xf xf2 = string != null ? new xn(string, wx.zzIZ()) : wx.zzIZ();
        return this.zza(xf2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new ww(d, wx.zzIZ()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new wi(bl, wx.zzIZ()), string);
    }

    private final Query zza(xf xf2, String string) {
        yw.zzhd(string);
        if (!xf2.zzIO() && !xf2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzbZm.zzId()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        wj wj2 = string != null ? wj.zzgT(string) : null;
        vn vn2 = this.zzbZm.zza(xf2, wj2);
        Query.zzb(vn2);
        Query.zza(vn2);
        return new Query(this.zzbYW, this.zzbZi, vn2, this.zzbZn);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        xf xf2 = string != null ? new xn(string, wx.zzIZ()) : wx.zzIZ();
        return this.zzb(xf2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new ww(d, wx.zzIZ()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new wi(bl, wx.zzIZ()), string);
    }

    private final Query zzb(xf xf2, String string) {
        wj wj2;
        yw.zzhd(string);
        if (!xf2.zzIO() && !xf2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        wj wj3 = wj2 = string != null ? wj.zzgT(string) : null;
        if (this.zzbZm.zzIg()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        vn vn2 = this.zzbZm.zzb(xf2, wj2);
        Query.zzb(vn2);
        Query.zza(vn2);
        return new Query(this.zzbYW, this.zzbZi, vn2, this.zzbZn);
    }

    public Query equalTo(String string) {
        this.zzFn();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzFn();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzFn();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzFn();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzFn();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzFn();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbZm.zzIj()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbYW, this.zzbZi, this.zzbZm.zzbW(n), this.zzbZn);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbZm.zzIj()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbYW, this.zzbZi, this.zzbZm.zzbX(n), this.zzbZn);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        yw.zzhb(string);
        this.zzFo();
        qo qo2 = new qo(string);
        if (qo2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        xj xj2 = new xj(qo2);
        return new Query(this.zzbYW, this.zzbZi, this.zzbZm.zza(xj2), true);
    }

    public Query orderByPriority() {
        this.zzFo();
        vn vn2 = this.zzbZm.zza(xk.zzJj());
        Query.zza(vn2);
        return new Query(this.zzbYW, this.zzbZi, vn2, true);
    }

    public Query orderByKey() {
        this.zzFo();
        vn vn2 = this.zzbZm.zza(xa.zzJf());
        Query.zza(vn2);
        return new Query(this.zzbYW, this.zzbZi, vn2, true);
    }

    public Query orderByValue() {
        this.zzFo();
        return new Query(this.zzbYW, this.zzbZi, this.zzbZm.zza(xo.zzJk()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzbYW, this.zzbZi);
    }

    public final qo zzFp() {
        return this.zzbZi;
    }

    public final vp zzFq() {
        return new vp(this.zzbZi, this.zzbZm);
    }
}

