/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.nc;
import com.google.android.gms.internal.nd;
import com.google.android.gms.internal.ne;
import com.google.android.gms.internal.pz;
import com.google.android.gms.internal.qd;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.tm;
import com.google.android.gms.internal.ui;
import com.google.android.gms.internal.uj;
import com.google.android.gms.internal.un;
import com.google.android.gms.internal.uv;
import com.google.android.gms.internal.vq;
import com.google.android.gms.internal.vt;
import com.google.android.gms.internal.wl;
import com.google.android.gms.internal.wp;
import com.google.android.gms.internal.wr;
import com.google.android.gms.internal.xd;
import com.google.android.gms.internal.xl;
import com.google.android.gms.internal.xm;
import com.google.android.gms.internal.xp;
import com.google.android.gms.internal.yr;
import com.google.android.gms.internal.yy;
import com.google.android.gms.internal.za;
import com.google.android.gms.internal.zd;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class nb
implements ui {
    private static final Charset zzayt = Charset.forName("UTF-8");
    private final SQLiteDatabase zzbZD;
    private final wl zzbZE;
    private boolean zzbZF;
    private long zzbZG = 0L;

    public nb(Context context, qd qd2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzbZE = qd2.zzgP("Persistence");
        this.zzbZD = nb.zzN(context, string2);
    }

    @Override
    public final void zza(qr qr2, xm xm2, long l) {
        this.zzFw();
        long l2 = System.currentTimeMillis();
        byte[] byArray = nb.zzW(xm2.getValue(true));
        this.zza(qr2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(qr qr2, pz pz2, long l) {
        this.zzFw();
        long l2 = System.currentTimeMillis();
        byte[] byArray = nb.zzW(pz2.zzaD(true));
        this.zza(qr2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzal(long l) {
        this.zzFw();
        long l2 = System.currentTimeMillis();
        int n = this.zzbZD.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<tm> zzFs() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<tm> arrayList = new ArrayList<tm>();
        try (Cursor cursor = this.zzbZD.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<tm> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                tm tm2;
                Iterable<xl> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new qr(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = nb.zzQ(arrayList3);
                }
                Object object = yr.zzgW((String)new String(byArray, zzayt));
                if ("o".equals(string)) {
                    iterable = xp.zza(object, xd.zzJb());
                    tm2 = new tm(l2, (qr)((Object)arrayList2), (xm)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = pz.zzD((Map)object);
                    tm2 = new tm(l2, (qr)((Object)arrayList2), (pz)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(tm2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbZE.zzIH()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzbZE.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(qr qr2, long l, String string, byte[] byArray) {
        this.zzFw();
        this.zzbZD.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = nb.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", nb.zzc(qr2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzbZD.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", nb.zzc(qr2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzbZD.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final xm zza(qr qr2) {
        return this.zzb(qr2);
    }

    @Override
    public final void zza(qr qr2, xm xm2) {
        this.zzFw();
        this.zza(qr2, xm2, false);
    }

    @Override
    public final void zzb(qr qr2, xm xm2) {
        this.zzFw();
        this.zza(qr2, xm2, true);
    }

    private final void zza(qr qr2, xm xm2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", qr2);
            n = this.zzc(qr2, xm2);
        } else {
            n2 = 0;
            n = 0;
            for (xl xl2 : xm2) {
                n2 += this.zza("serverCache", qr2.zza(xl2.zzJk()));
                n += this.zzc(qr2.zza(xl2.zzJk()), xl2.zzFn());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, qr2.toString(), l2);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(qr qr2, pz pz2) {
        this.zzFw();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<qr, xm> entry : pz2) {
            n2 += this.zza("serverCache", qr2.zzh(entry.getKey()));
            n += this.zzc(qr2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, qr2.toString(), l2);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzFt() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzbZD.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(un un2) {
        this.zzFw();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(un2.id));
        contentValues.put("path", nb.zzc(un2.zzcgi.zzFq()));
        contentValues.put("queryParams", un2.zzcgi.zzIu().zzIr());
        contentValues.put("lastUse", Long.valueOf(un2.zzcgj));
        contentValues.put("complete", Boolean.valueOf(un2.complete));
        contentValues.put("active", Boolean.valueOf(un2.zzbpf));
        this.zzbZD.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzam(long l) {
        this.zzFw();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbZD.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzbZD.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<un> zzFu() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<un> arrayList = new ArrayList<un>();
        try (Cursor cursor = this.zzbZD.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<un> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new qr(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = yr.zzgV((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<un> arrayList3 = arrayList2;
                objectArray = vq.zzF((Map<String, Object>)object);
                vt vt2 = new vt((qr)((Object)arrayList3), (vq)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                un un2 = new un(l2, vt2, l3, bl, bl2);
                arrayList.add(un2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbZE.zzIH()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzbZE.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzan(long l) {
        this.zzFw();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzbZD.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzbZE.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<wp> set) {
        this.zzFw();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbZD.delete("trackedKeys", string2, new String[]{string});
        for (wp wp2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", wp2.asString());
            this.zzbZD.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzbZE.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<wp> set, Set<wp> set2) {
        this.zzFw();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (wp wp2 : set2) {
            this.zzbZD.delete("trackedKeys", string, new String[]{string2, wp2.asString()});
        }
        for (wp wp2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", wp2.asString());
            this.zzbZD.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzbZE.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<wp> zzao(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<wp> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(nb.zzj(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzbZD.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(wp.zzgT(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzbZE.zzIH()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzbZE.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(qr qr2, uj uj2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<wp> iterable2;
        if (!uj2.zzHN()) {
            return;
        }
        this.zzFw();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(qr2, new String[]{"rowid", "path"});
        uv<Object> uv2 = new uv<Object>(null);
        uv<Object> uv3 = new uv<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new qr(cursor.getString(1));
            if (!qr2.zzi((qr)iterable2)) {
                iterable = String.valueOf(qr2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzbZE.zze(string2, null);
                continue;
            }
            iterable = qr.zza(qr2, (qr)iterable2);
            if (uj2.zzv((qr)iterable)) {
                uv2 = uv2.zzb((qr)iterable, l2);
                continue;
            }
            if (uj2.zzw((qr)iterable)) {
                uv3 = uv3.zzb((qr)iterable, l2);
                continue;
            }
            string3 = String.valueOf(qr2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzbZE.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!uv2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(qr2, qr.zzGZ(), uv2, uv3, uj2, (List<za<qr, xm>>)iterable2);
            iterable = uv2.values();
            string = String.valueOf(nb.zzj(iterable));
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzbZD.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                za za2 = (za)e;
                this.zzc(qr2.zzh((qr)za2.getFirst()), (xm)za2.zzJG());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzbZE.zzb(string2, null, objectArray);
        }
    }

    private final void zza(qr qr2, qr qr3, uv<Long> uv2, uv<Long> uv3, uj uj2, List<za<qr, xm>> list) {
        if (uv2.getValue() != null) {
            int n = uj2.zza(0, new nc(this, uv3));
            if (n > 0) {
                qr qr4 = qr2.zzh(qr3);
                if (this.zzbZE.zzIH()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, qr4);
                    this.zzbZE.zzb(string, null, objectArray);
                }
                xm xm2 = this.zzb(qr4);
                uj2.zza(null, new nd(this, uv3, list, qr3, xm2));
            }
            return;
        }
        for (Map.Entry<wp, uv<Long>> entry : uv2.zzHS()) {
            wp wp2 = entry.getKey();
            uj uj3 = uj2.zzd(entry.getKey());
            this.zza(qr2, qr3.zza(wp2), entry.getValue(), uv3.zze(wp2), uj3, list);
        }
    }

    @Override
    public final void zzFv() {
        this.zzFw();
        long l = System.currentTimeMillis();
        int n = this.zzbZD.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zd.zzb(!this.zzbZF, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzbZE.zzb("Starting transaction.", null, objectArray);
        }
        this.zzbZD.beginTransaction();
        this.zzbZF = true;
        this.zzbZG = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzbZD.endTransaction();
        this.zzbZF = false;
        long l = System.currentTimeMillis() - this.zzbZG;
        if (this.zzbZE.zzIH()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzbZE.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzbZD.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzN(Context context, String string) {
        ne ne2 = new ne(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = ne2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzFw() {
        zd.zzb(this.zzbZF, "Transaction expected to already be in progress.");
    }

    private final int zzc(qr qr2, xm xm2) {
        long l = yy.zzn(xm2);
        if (xm2 instanceof wr && l > 16384L) {
            if (this.zzbZE.zzIH()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", qr2, l, 16384);
                this.zzbZE.zzb(string, null, objectArray);
            }
            int n = 0;
            for (xl xl2 : xm2) {
                n += this.zzc(qr2.zza(xl2.zzJk()), xl2.zzFn());
            }
            if (!xm2.zzIR().isEmpty()) {
                this.zzd(qr2.zza(wp.zzIL()), xm2.zzIR());
                ++n;
            }
            this.zzd(qr2, xd.zzJb());
            return ++n;
        }
        this.zzd(qr2, xm2);
        return 1;
    }

    private static String zza(qr qr2, int n) {
        String string = String.valueOf(nb.zzc(qr2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(qr qr2, xm xm2) {
        byte[] byArray = nb.zzW(xm2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = nb.zzd(byArray, 262144);
            if (this.zzbZE.zzIH()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzbZE.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", nb.zza(qr2, n));
                contentValues.put("value", list.get(n));
                this.zzbZD.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", nb.zzc(qr2));
        contentValues.put("value", byArray);
        this.zzbZD.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final xm zzb(qr qr2) {
        String string;
        Object[] objectArray;
        qr qr3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(qr2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        xm xm2 = xd.zzJb();
        boolean bl = false;
        HashMap<qr, void> hashMap = new HashMap<qr, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                qr3 = new qr(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = nb.zza(qr3, arrayList, i);
                if (this.zzbZE.zzIH()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzbZE.zzb(string, null, objectArray);
                }
                xm xm3 = nb.zzB(nb.zzQ(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                xm xm4 = nb.zzB((byte[])arrayList2.get(i));
                qr3 = new qr((String)arrayList.get(i));
            }
            if (qr3.zzHf() != null && qr3.zzHf().zzIN()) {
                hashMap.put(qr3, object);
                continue;
            }
            if (qr3.zzi(qr2)) {
                zd.zzb(!bl, "Descendants of path must come after ancestors.");
                xm2 = object.zzN(qr.zza(qr3, qr2));
                continue;
            }
            if (qr2.zzi(qr3)) {
                bl = true;
                object2 = qr.zza(qr2, qr3);
                xm2 = xm2.zzl((qr)object2, (xm)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", qr3, qr2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            qr3 = (qr)entry.getKey();
            xm2 = xm2.zzl(qr.zza(qr2, qr3), (xm)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzbZE.zzIH()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), yy.zzo(xm2), qr2, l7, l2, l4, l6);
            this.zzbZE.zzb(string, null, objectArray);
        }
        return xm2;
    }

    private static int zza(qr qr2, List<String> list, int n) {
        int n2;
        String string = nb.zzc(qr2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(nb.zza(qr2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(qr qr2, String[] stringArray) {
        String[] stringArray2;
        String string = nb.zzc(qr2);
        String string2 = nb.zzgC(string);
        String[] stringArray3 = stringArray2 = new String[qr2.size() + 3];
        qr qr3 = qr2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!qr3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = nb.zzc(qr3);
            qr3 = qr3.zzHe();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = nb.zzc(qr.zzGZ());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[qr2.size() + 1] = string;
        stringArray2[qr2.size() + 2] = string2;
        String string6 = "path";
        return this.zzbZD.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(qr qr2) {
        if (qr2.isEmpty()) {
            return "/";
        }
        return String.valueOf(qr2.toString()).concat("/");
    }

    private static String zzgC(String string) {
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, qr qr2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = nb.zzc(qr2);
        String string4 = nb.zzgC(string3);
        return this.zzbZD.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzQ(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzW(Object object) {
        try {
            return yr.zzak((Object)object).getBytes(zzayt);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static xm zzB(byte[] byArray) {
        try {
            return xp.zza(yr.zzgW((String)new String(byArray, zzayt)), xd.zzJb());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzayt);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzj(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

