/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.pz;
import com.google.android.gms.internal.qg;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.qu;
import com.google.android.gms.internal.ry;
import com.google.android.gms.internal.tn;
import com.google.android.gms.internal.wp;
import com.google.android.gms.internal.xm;
import com.google.android.gms.internal.xp;
import com.google.android.gms.internal.xs;
import com.google.android.gms.internal.za;
import com.google.android.gms.internal.zc;
import com.google.android.gms.internal.zd;
import com.google.android.gms.internal.zf;
import com.google.android.gms.internal.zg;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static qg zzbYL;

    DatabaseReference(qu qu2, qr qr2) {
        super(qu2, qr2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzbZf.isEmpty()) {
            zf.zzhc(string);
        } else {
            zf.zzhb(string);
        }
        qr qr2 = this.zzbZf.zzh(new qr(string));
        return new DatabaseReference(this.zzbYY, qr2);
    }

    public DatabaseReference push() {
        wp wp2 = wp.zzgT(zc.zzaz(this.zzbYY.zzHi()));
        return new DatabaseReference(this.zzbYY, this.zzbZf.zza(wp2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, xs.zzc(this.zzbZf, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, xs.zzc(this.zzbZf, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, xs.zzc(this.zzbZf, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, xs.zzc(this.zzbZf, object2), completionListener);
    }

    private final Task<Void> zza(Object object, xm xm2, CompletionListener completionListener) {
        zf.zzO(this.zzbZf);
        tn.zza(this.zzbZf, object);
        Object object2 = zg.zzan(object);
        zf.zzam(object2);
        xm xm3 = xp.zza(object2, xm2);
        za<Task<Void>, CompletionListener> za2 = zd.zzb(completionListener);
        this.zzbYY.zzq(new zzc(this, xm3, za2));
        return za2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(xs.zzc(this.zzbZf, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(xs.zzc(this.zzbZf, object), completionListener);
    }

    private final Task<Void> zza(xm xm2, CompletionListener completionListener) {
        zf.zzO(this.zzbZf);
        za<Task<Void>, CompletionListener> za2 = zd.zzb(completionListener);
        this.zzbYY.zzq(new zzd(this, xm2, za2));
        return za2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zg.zzG(map);
        pz pz2 = pz.zzE(zf.zzb(this.zzbZf, map2));
        za<Task<Void>, CompletionListener> za2 = zd.zzb(completionListener);
        this.zzbYY.zzq(new zze(this, pz2, za2, map2));
        return za2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zf.zzO(this.zzbZf);
        return new OnDisconnect(this.zzbYY, this.zzbZf);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zf.zzO(this.zzbZf);
        this.zzbYY.zzq(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        ry.zzd(DatabaseReference.zzFl());
    }

    public static void goOnline() {
        ry.zze(DatabaseReference.zzFl());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzbYY.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzbYY.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        qr qr2 = this.zzbZf.zzHe();
        if (qr2 != null) {
            return new DatabaseReference(this.zzbYY, qr2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzbYY, new qr(""));
    }

    public String getKey() {
        if (this.zzbZf.isEmpty()) {
            return null;
        }
        return this.zzbZf.zzHf().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized qg zzFl() {
        if (zzbYL == null) {
            zzbYL = new qg();
        }
        return zzbYL;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

