/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdpy;
import com.google.android.gms.internal.zzdqf;
import com.google.android.gms.internal.zzdqq;
import com.google.android.gms.internal.zzdqt;
import com.google.android.gms.internal.zzdrx;
import com.google.android.gms.internal.zzdtm;
import com.google.android.gms.internal.zzdwo;
import com.google.android.gms.internal.zzdxl;
import com.google.android.gms.internal.zzdxo;
import com.google.android.gms.internal.zzdxr;
import com.google.android.gms.internal.zzdyz;
import com.google.android.gms.internal.zzdzb;
import com.google.android.gms.internal.zzdzc;
import com.google.android.gms.internal.zzdze;
import com.google.android.gms.internal.zzdzf;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzdqf zzllm;

    DatabaseReference(zzdqt zzdqt2, zzdqq zzdqq2) {
        super(zzdqt2, zzdqq2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzlmg.isEmpty()) {
            zzdze.zzpn(string);
        } else {
            zzdze.zzpm(string);
        }
        zzdqq zzdqq2 = this.zzlmg.zzh(new zzdqq(string));
        return new DatabaseReference(this.zzllz, zzdqq2);
    }

    public DatabaseReference push() {
        zzdwo zzdwo2 = zzdwo.zzpe(zzdzb.zzby(this.zzllz.zzbtc()));
        return new DatabaseReference(this.zzllz, this.zzlmg.zza(zzdwo2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzdxr.zzc(this.zzlmg, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzdxr.zzc(this.zzlmg, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzdxr.zzc(this.zzlmg, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzdxr.zzc(this.zzlmg, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzdxl zzdxl2, CompletionListener completionListener) {
        zzdze.zzao(this.zzlmg);
        zzdtm.zza(this.zzlmg, object);
        Object object2 = zzdzf.zzbn(object);
        zzdze.zzbm(object2);
        zzdxl zzdxl3 = zzdxo.zza(object2, zzdxl2);
        zzdyz<Task<Void>, CompletionListener> zzdyz2 = zzdzc.zzb(completionListener);
        this.zzllz.zzn(new zzc(this, zzdxl3, zzdyz2));
        return zzdyz2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzdxr.zzc(this.zzlmg, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzdxr.zzc(this.zzlmg, object), completionListener);
    }

    private final Task<Void> zza(zzdxl zzdxl2, CompletionListener completionListener) {
        zzdze.zzao(this.zzlmg);
        zzdyz<Task<Void>, CompletionListener> zzdyz2 = zzdzc.zzb(completionListener);
        this.zzllz.zzn(new zzd(this, zzdxl2, zzdyz2));
        return zzdyz2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzdzf.zzah(map);
        zzdpy zzdpy2 = zzdpy.zzaf(zzdze.zzb(this.zzlmg, map2));
        zzdyz<Task<Void>, CompletionListener> zzdyz2 = zzdzc.zzb(completionListener);
        this.zzllz.zzn(new zze(this, zzdpy2, zzdyz2, map2));
        return zzdyz2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzdze.zzao(this.zzlmg);
        return new OnDisconnect(this.zzllz, this.zzlmg);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzdze.zzao(this.zzlmg);
        this.zzllz.zzn(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzdrx.zzd(DatabaseReference.zzbpf());
    }

    public static void goOnline() {
        zzdrx.zze(DatabaseReference.zzbpf());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzllz.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzllz.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzdqq zzdqq2 = this.zzlmg.zzbsy();
        if (zzdqq2 != null) {
            return new DatabaseReference(this.zzllz, zzdqq2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzllz, new zzdqq(""));
    }

    public String getKey() {
        if (this.zzlmg.isEmpty()) {
            return null;
        }
        return this.zzlmg.zzbsz().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzdqf zzbpf() {
        if (zzllm == null) {
            zzllm = new zzdqf();
        }
        return zzllm;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

