/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzdql;
import com.google.android.gms.internal.zzdqw;
import com.google.android.gms.internal.zzdqz;
import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdsd;
import com.google.android.gms.internal.zzdzg;
import com.google.android.gms.internal.zzdzi;
import com.google.android.gms.internal.zzdzk;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzdsc, FirebaseDatabase>> zzllv = new HashMap<String, Map<zzdsc, FirebaseDatabase>>();
    private final FirebaseApp zzllw;
    private final zzdsc zzllx;
    private final zzdql zzlly;
    private zzdqz zzllz;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzdsc, FirebaseDatabase> map = zzllv.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzdsc, FirebaseDatabase>();
            zzllv.put(firebaseApp.getName(), map);
        }
        zzdzg zzdzg2 = zzdzi.zzpi(string);
        if (!zzdzg2.zzlmg.isEmpty()) {
            String string2 = zzdzg2.zzlmg.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzdzg2.zzllx);
        if (firebaseDatabase == null) {
            zzdql zzdql2 = new zzdql();
            if (!firebaseApp.zzbnk()) {
                zzdql2.zzpc(firebaseApp.getName());
            }
            zzdql2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzdzg2.zzllx, zzdql2);
            map.put(zzdzg2.zzllx, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzdsc zzdsc2, zzdql zzdql2) {
        this.zzllw = firebaseApp;
        this.zzllx = zzdsc2;
        this.zzlly = zzdql2;
    }

    public FirebaseApp getApp() {
        return this.zzllw;
    }

    public DatabaseReference getReference() {
        this.zzbpg();
        return new DatabaseReference(this.zzllz, zzdqw.zzbst());
    }

    public DatabaseReference getReference(String string) {
        this.zzbpg();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzdzk.zzpn(string);
        zzdqw zzdqw2 = new zzdqw(string);
        return new DatabaseReference(this.zzllz, zzdqw2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbpg();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzdzg zzdzg2 = zzdzi.zzpi(string);
        if (!zzdzg2.zzllx.host.equals(this.zzllz.zzbtb().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzllz, zzdzg2.zzlmg);
    }

    public void purgeOutstandingWrites() {
        this.zzbpg();
        this.zzllz.zzn(new zzg(this));
    }

    public void goOnline() {
        this.zzbpg();
        zzdsd.zzl(this.zzllz);
    }

    public void goOffline() {
        this.zzbpg();
        zzdsd.zzk(this.zzllz);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzom("setLogLevel");
        this.zzlly.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzom("setPersistenceEnabled");
        this.zzlly.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzom("setPersistenceCacheSizeBytes");
        this.zzlly.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzom(String string) {
        if (this.zzllz != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbpg() {
        if (this.zzllz == null) {
            this.zzllz = zzdsd.zza(this.zzlly, this.zzllx, this);
        }
    }

    static /* synthetic */ zzdqz zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzllz;
    }
}

