/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdqc;
import com.google.android.gms.internal.zzdqn;
import com.google.android.gms.internal.zzdqw;
import com.google.android.gms.internal.zzdqz;
import com.google.android.gms.internal.zzdtt;
import com.google.android.gms.internal.zzdty;
import com.google.android.gms.internal.zzdvv;
import com.google.android.gms.internal.zzdvy;
import com.google.android.gms.internal.zzdwt;
import com.google.android.gms.internal.zzdwu;
import com.google.android.gms.internal.zzdxh;
import com.google.android.gms.internal.zzdxi;
import com.google.android.gms.internal.zzdxl;
import com.google.android.gms.internal.zzdxr;
import com.google.android.gms.internal.zzdxv;
import com.google.android.gms.internal.zzdxw;
import com.google.android.gms.internal.zzdxx;
import com.google.android.gms.internal.zzdxz;
import com.google.android.gms.internal.zzdyb;
import com.google.android.gms.internal.zzdzi;
import com.google.android.gms.internal.zzdzk;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzdqz zzllz;
    protected final zzdqw zzlmg;
    private zzdvv zzlmk;
    private final boolean zzlml;

    private Query(zzdqz zzdqz2, zzdqw zzdqw2, zzdvv zzdvv2, boolean bl) throws DatabaseException {
        this.zzllz = zzdqz2;
        this.zzlmg = zzdqw2;
        this.zzlmk = zzdvv2;
        this.zzlml = bl;
        zzdvv zzdvv3 = zzdvv2;
        zzdzi.zzb(!zzdvv3.zzbuy() || !zzdvv3.zzbvb() || !zzdvv3.zzbve() || zzdvv3.zzbvf(), "Validation of queries failed.");
    }

    Query(zzdqz zzdqz2, zzdqw zzdqw2) {
        this.zzllz = zzdqz2;
        this.zzlmg = zzdqw2;
        this.zzlmk = zzdvv.zzmca;
        this.zzlml = false;
    }

    private static void zza(zzdvv zzdvv2) {
        if (zzdvv2.zzbvg().equals(zzdxl.zzbxa())) {
            zzdxr zzdxr2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzdvv2.zzbuy()) {
                zzdxr2 = zzdvv2.zzbuz();
                if (zzdvv2.zzbva() != zzdwu.zzbwc() || !(zzdxr2 instanceof zzdxz)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzdvv2.zzbvb()) {
                zzdxr2 = zzdvv2.zzbvc();
                if (zzdvv2.zzbvd() != zzdwu.zzbwd() || !(zzdxr2 instanceof zzdxz)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzdvv2.zzbvg().equals(zzdxw.zzbxe()) && (zzdvv2.zzbuy() && !zzdxx.zzl(zzdvv2.zzbuz()) || zzdvv2.zzbvb() && !zzdxx.zzl(zzdvv2.zzbvc()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzdvv zzdvv2) {
        if (zzdvv2.zzbuy() && zzdvv2.zzbvb() && zzdvv2.zzbve() && !zzdvv2.zzbvf()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbpi() {
        if (this.zzlmk.zzbuy()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzlmk.zzbvb()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbpj() {
        if (this.zzlml) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzdtt(this.zzllz, valueEventListener, this.zzbpl()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzdqc(this.zzllz, childEventListener, this.zzbpl()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzdtt(this.zzllz, new zzp(this, valueEventListener), this.zzbpl()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdtt(this.zzllz, valueEventListener, this.zzbpl()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdqc(this.zzllz, childEventListener, this.zzbpl()));
    }

    private final void zza(zzdqn zzdqn2) {
        zzdty.zzbtu().zzj(zzdqn2);
        this.zzllz.zzn(new zzq(this, zzdqn2));
    }

    private final void zzb(zzdqn zzdqn2) {
        zzdty.zzbtu().zzi(zzdqn2);
        this.zzllz.zzn(new zzr(this, zzdqn2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzlmg.isEmpty() && this.zzlmg.zzbsw().equals(zzdwu.zzbwf())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzllz.zzn(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzdxr zzdxr2 = string != null ? new zzdxz(string, zzdxi.zzbwu()) : zzdxi.zzbwu();
        return this.zza(zzdxr2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzdxh(d, zzdxi.zzbwu()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzdwt(bl, zzdxi.zzbwu()), string);
    }

    private final Query zza(zzdxr zzdxr2, String string) {
        zzdzk.zzpo(string);
        if (!zzdxr2.zzbwj() && !zzdxr2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzlmk.zzbuy()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzdwu zzdwu2 = string != null ? zzdwu.zzpe(string) : null;
        zzdvv zzdvv2 = this.zzlmk.zza(zzdxr2, zzdwu2);
        Query.zzb(zzdvv2);
        Query.zza(zzdvv2);
        return new Query(this.zzllz, this.zzlmg, zzdvv2, this.zzlml);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzdxr zzdxr2 = string != null ? new zzdxz(string, zzdxi.zzbwu()) : zzdxi.zzbwu();
        return this.zzb(zzdxr2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzdxh(d, zzdxi.zzbwu()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzdwt(bl, zzdxi.zzbwu()), string);
    }

    private final Query zzb(zzdxr zzdxr2, String string) {
        zzdwu zzdwu2;
        zzdzk.zzpo(string);
        if (!zzdxr2.zzbwj() && !zzdxr2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzdwu zzdwu3 = zzdwu2 = string != null ? zzdwu.zzpe(string) : null;
        if (this.zzlmk.zzbvb()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzdvv zzdvv2 = this.zzlmk.zzb(zzdxr2, zzdwu2);
        Query.zzb(zzdvv2);
        Query.zza(zzdvv2);
        return new Query(this.zzllz, this.zzlmg, zzdvv2, this.zzlml);
    }

    public Query equalTo(String string) {
        this.zzbpi();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbpi();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbpi();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbpi();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbpi();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbpi();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlmk.zzbve()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zzft(n), this.zzlml);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlmk.zzbve()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zzfu(n), this.zzlml);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzdzk.zzpm(string);
        this.zzbpj();
        zzdqw zzdqw2 = new zzdqw(string);
        if (zzdqw2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzdxv zzdxv2 = new zzdxv(zzdqw2);
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zza(zzdxv2), true);
    }

    public Query orderByPriority() {
        this.zzbpj();
        zzdvv zzdvv2 = this.zzlmk.zza(zzdxw.zzbxe());
        Query.zza(zzdvv2);
        return new Query(this.zzllz, this.zzlmg, zzdvv2, true);
    }

    public Query orderByKey() {
        this.zzbpj();
        zzdvv zzdvv2 = this.zzlmk.zza(zzdxl.zzbxa());
        Query.zza(zzdvv2);
        return new Query(this.zzllz, this.zzlmg, zzdvv2, true);
    }

    public Query orderByValue() {
        this.zzbpj();
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zza(zzdyb.zzbxf()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzllz, this.zzlmg);
    }

    public final zzdqw zzbpk() {
        return this.zzlmg;
    }

    public final zzdvy zzbpl() {
        return new zzdvy(this.zzlmg, this.zzlmk);
    }
}

