/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzdnn;
import com.google.android.gms.internal.zzdno;
import com.google.android.gms.internal.zzdnp;
import com.google.android.gms.internal.zzdqk;
import com.google.android.gms.internal.zzdqo;
import com.google.android.gms.internal.zzdrc;
import com.google.android.gms.internal.zzdtx;
import com.google.android.gms.internal.zzdut;
import com.google.android.gms.internal.zzduu;
import com.google.android.gms.internal.zzduy;
import com.google.android.gms.internal.zzdvg;
import com.google.android.gms.internal.zzdwb;
import com.google.android.gms.internal.zzdwe;
import com.google.android.gms.internal.zzdww;
import com.google.android.gms.internal.zzdxa;
import com.google.android.gms.internal.zzdxc;
import com.google.android.gms.internal.zzdxo;
import com.google.android.gms.internal.zzdxw;
import com.google.android.gms.internal.zzdxx;
import com.google.android.gms.internal.zzdya;
import com.google.android.gms.internal.zzdzc;
import com.google.android.gms.internal.zzdzj;
import com.google.android.gms.internal.zzdzl;
import com.google.android.gms.internal.zzdzo;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzdnm
implements zzdut {
    private static final Charset zzfcc = Charset.forName("UTF-8");
    private final SQLiteDatabase zzlpr;
    private final zzdww zzlps;
    private boolean zzlpt;
    private long zzlpu = 0L;

    public zzdnm(Context context, zzdqo zzdqo2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzlps = zzdqo2.zzpk("Persistence");
        this.zzlpr = zzdnm.zzan(context, string2);
    }

    @Override
    public final void zza(zzdrc zzdrc2, zzdxx zzdxx2, long l) {
        this.zzbpt();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdnm.zzav(zzdxx2.getValue(true));
        this.zza(zzdrc2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzdrc zzdrc2, zzdqk zzdqk2, long l) {
        this.zzbpt();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdnm.zzav(zzdqk2.zzcg(true));
        this.zza(zzdrc2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbk(long l) {
        this.zzbpt();
        long l2 = System.currentTimeMillis();
        int n = this.zzlpr.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzdtx> zzbpp() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzdtx> arrayList = new ArrayList<zzdtx>();
        try (Cursor cursor = this.zzlpr.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzdtx> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzdtx zzdtx2;
                Iterable<zzdxw> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzdrc(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzdnm.zzao(arrayList3);
                }
                Object object = zzdzc.zzpr((String)new String(byArray, zzfcc));
                if ("o".equals(string)) {
                    iterable = zzdya.zza(object, zzdxo.zzbwx());
                    zzdtx2 = new zzdtx(l2, (zzdrc)((Object)arrayList2), (zzdxx)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzdqk.zzae((Map)object);
                    zzdtx2 = new zzdtx(l2, (zzdrc)((Object)arrayList2), (zzdqk)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzdtx2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzlps.zzbwd()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzlps.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzdrc zzdrc2, long l, String string, byte[] byArray) {
        this.zzbpt();
        this.zzlpr.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzdnm.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzdnm.zzc(zzdrc2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzlpr.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzdnm.zzc(zzdrc2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzlpr.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzdxx zza(zzdrc zzdrc2) {
        return this.zzb(zzdrc2);
    }

    @Override
    public final void zza(zzdrc zzdrc2, zzdxx zzdxx2) {
        this.zzbpt();
        this.zza(zzdrc2, zzdxx2, false);
    }

    @Override
    public final void zzb(zzdrc zzdrc2, zzdxx zzdxx2) {
        this.zzbpt();
        this.zza(zzdrc2, zzdxx2, true);
    }

    private final void zza(zzdrc zzdrc2, zzdxx zzdxx2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzdrc2);
            n = this.zzc(zzdrc2, zzdxx2);
        } else {
            n2 = 0;
            n = 0;
            for (zzdxw zzdxw2 : zzdxx2) {
                n2 += this.zza("serverCache", zzdrc2.zza(zzdxw2.zzbxg()));
                n += this.zzc(zzdrc2.zza(zzdxw2.zzbxg()), zzdxw2.zzbpk());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzdrc2.toString(), l2);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzdrc zzdrc2, zzdqk zzdqk2) {
        this.zzbpt();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzdrc, zzdxx> entry : zzdqk2) {
            n2 += this.zza("serverCache", zzdrc2.zzh(entry.getKey()));
            n += this.zzc(zzdrc2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzdrc2.toString(), l2);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbpq() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzlpr.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzduy zzduy2) {
        this.zzbpt();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzduy2.id));
        contentValues.put("path", zzdnm.zzc(zzduy2.zzmcw.zzbpn()));
        contentValues.put("queryParams", zzduy2.zzmcw.zzbvq().zzbvo());
        contentValues.put("lastUse", Long.valueOf(zzduy2.zzmcx));
        contentValues.put("complete", Boolean.valueOf(zzduy2.complete));
        contentValues.put("active", Boolean.valueOf(zzduy2.zzimi));
        this.zzlpr.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbl(long l) {
        this.zzbpt();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzlpr.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzlpr.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzduy> zzbpr() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzduy> arrayList = new ArrayList<zzduy>();
        try (Cursor cursor = this.zzlpr.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzduy> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzdrc(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzdzc.zzpq((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzduy> arrayList3 = arrayList2;
                objectArray = zzdwb.zzag((Map<String, Object>)object);
                zzdwe zzdwe2 = new zzdwe((zzdrc)((Object)arrayList3), (zzdwb)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzduy zzduy2 = new zzduy(l2, zzdwe2, l3, bl, bl2);
                arrayList.add(zzduy2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzlps.zzbwd()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzlps.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbpt();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzlpr.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzlps.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzdxa> set) {
        this.zzbpt();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzlpr.delete("trackedKeys", string2, new String[]{string});
        for (zzdxa zzdxa2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzdxa2.asString());
            this.zzlpr.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzlps.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzdxa> set, Set<zzdxa> set2) {
        this.zzbpt();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzdxa zzdxa2 : set2) {
            this.zzlpr.delete("trackedKeys", string, new String[]{string2, zzdxa2.asString()});
        }
        for (zzdxa zzdxa2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzdxa2.asString());
            this.zzlpr.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzlps.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzdxa> zzbn(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<zzdxa> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = "id IN (";
        Object object = zzdnm.zzq(set);
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzlpr.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzdxa.zzpo(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzlps.zzbwd()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzlps.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzdrc zzdrc2, zzduu zzduu2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzdxa> iterable2;
        if (!zzduu2.zzbuk()) {
            return;
        }
        this.zzbpt();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzdrc2, new String[]{"rowid", "path"});
        zzdvg<Object> zzdvg2 = new zzdvg<Object>(null);
        zzdvg<Object> zzdvg3 = new zzdvg<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzdrc(cursor.getString(1));
            if (!zzdrc2.zzi((zzdrc)iterable2)) {
                iterable = String.valueOf(zzdrc2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzlps.zze(string2, null);
                continue;
            }
            iterable = zzdrc.zza(zzdrc2, (zzdrc)iterable2);
            if (zzduu2.zzv((zzdrc)iterable)) {
                zzdvg2 = zzdvg2.zzb((zzdrc)iterable, l2);
                continue;
            }
            if (zzduu2.zzw((zzdrc)iterable)) {
                zzdvg3 = zzdvg3.zzb((zzdrc)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzdrc2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzlps.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzdvg2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzdrc2, zzdrc.zzbsw(), zzdvg2, zzdvg3, zzduu2, (List<zzdzl<zzdrc, zzdxx>>)iterable2);
            iterable = zzdvg2.values();
            string = zzdnm.zzq(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzlpr.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzdzl zzdzl2 = (zzdzl)e;
                this.zzc(zzdrc2.zzh((zzdrc)zzdzl2.getFirst()), (zzdxx)zzdzl2.zzbya());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzlps.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzdrc zzdrc2, zzdrc zzdrc3, zzdvg<Long> zzdvg2, zzdvg<Long> zzdvg3, zzduu zzduu2, List<zzdzl<zzdrc, zzdxx>> list) {
        if (zzdvg2.getValue() != null) {
            int n = zzduu2.zza(0, new zzdnn(this, zzdvg3));
            if (n > 0) {
                zzdrc zzdrc4 = zzdrc2.zzh(zzdrc3);
                if (this.zzlps.zzbwd()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzdrc4);
                    this.zzlps.zzb(string, null, objectArray);
                }
                zzdxx zzdxx2 = this.zzb(zzdrc4);
                zzduu2.zza(null, new zzdno(this, zzdvg3, list, zzdrc3, zzdxx2));
            }
            return;
        }
        for (Map.Entry<zzdxa, zzdvg<Long>> entry : zzdvg2.zzbup()) {
            zzdxa zzdxa2 = entry.getKey();
            zzduu zzduu3 = zzduu2.zzd(entry.getKey());
            this.zza(zzdrc2, zzdrc3.zza(zzdxa2), entry.getValue(), zzdvg3.zze(zzdxa2), zzduu3, list);
        }
    }

    @Override
    public final void zzbps() {
        this.zzbpt();
        long l = System.currentTimeMillis();
        int n = this.zzlpr.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzdzo.zzb(!this.zzlpt, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzlps.zzb("Starting transaction.", null, objectArray);
        }
        this.zzlpr.beginTransaction();
        this.zzlpt = true;
        this.zzlpu = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzlpr.endTransaction();
        this.zzlpt = false;
        long l = System.currentTimeMillis() - this.zzlpu;
        if (this.zzlps.zzbwd()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzlps.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzlpr.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzan(Context context, String string) {
        zzdnp zzdnp2 = new zzdnp(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzdnp2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbpt() {
        zzdzo.zzb(this.zzlpt, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzdrc zzdrc2, zzdxx zzdxx2) {
        long l = zzdzj.zzn(zzdxx2);
        if (zzdxx2 instanceof zzdxc && l > 16384L) {
            if (this.zzlps.zzbwd()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzdrc2, l, 16384);
                this.zzlps.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzdxw zzdxw2 : zzdxx2) {
                n += this.zzc(zzdrc2.zza(zzdxw2.zzbxg()), zzdxw2.zzbpk());
            }
            if (!zzdxx2.zzbwn().isEmpty()) {
                this.zzd(zzdrc2.zza(zzdxa.zzbwh()), zzdxx2.zzbwn());
                ++n;
            }
            this.zzd(zzdrc2, zzdxo.zzbwx());
            return ++n;
        }
        this.zzd(zzdrc2, zzdxx2);
        return 1;
    }

    private static String zza(zzdrc zzdrc2, int n) {
        String string = String.valueOf(zzdnm.zzc(zzdrc2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzdrc zzdrc2, zzdxx zzdxx2) {
        byte[] byArray = zzdnm.zzav(zzdxx2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzdnm.zzd(byArray, 262144);
            if (this.zzlps.zzbwd()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzlps.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzdnm.zza(zzdrc2, n));
                contentValues.put("value", list.get(n));
                this.zzlpr.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzdnm.zzc(zzdrc2));
        contentValues.put("value", byArray);
        this.zzlpr.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzdxx zzb(zzdrc zzdrc2) {
        String string;
        Object[] objectArray;
        zzdrc zzdrc3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzdrc2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzdxx zzdxx2 = zzdxo.zzbwx();
        boolean bl = false;
        HashMap<zzdrc, void> hashMap = new HashMap<zzdrc, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzdrc3 = new zzdrc(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzdnm.zza(zzdrc3, arrayList, i);
                if (this.zzlps.zzbwd()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzlps.zzb(string, null, objectArray);
                }
                zzdxx zzdxx3 = zzdnm.zzal(zzdnm.zzao(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzdxx zzdxx4 = zzdnm.zzal((byte[])arrayList2.get(i));
                zzdrc3 = new zzdrc((String)arrayList.get(i));
            }
            if (zzdrc3.zzbtc() != null && zzdrc3.zzbtc().zzbwj()) {
                hashMap.put(zzdrc3, object);
                continue;
            }
            if (zzdrc3.zzi(zzdrc2)) {
                zzdzo.zzb(!bl, "Descendants of path must come after ancestors.");
                zzdxx2 = object.zzan(zzdrc.zza(zzdrc3, zzdrc2));
                continue;
            }
            if (zzdrc2.zzi(zzdrc3)) {
                bl = true;
                object2 = zzdrc.zza(zzdrc2, zzdrc3);
                zzdxx2 = zzdxx2.zzl((zzdrc)object2, (zzdxx)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzdrc3, zzdrc2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzdrc3 = (zzdrc)entry.getKey();
            zzdxx2 = zzdxx2.zzl(zzdrc.zza(zzdrc2, zzdrc3), (zzdxx)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzlps.zzbwd()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzdzj.zzo(zzdxx2), zzdrc2, l7, l2, l4, l6);
            this.zzlps.zzb(string, null, objectArray);
        }
        return zzdxx2;
    }

    private static int zza(zzdrc zzdrc2, List<String> list, int n) {
        int n2;
        String string = zzdnm.zzc(zzdrc2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzdnm.zza(zzdrc2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzdrc zzdrc2, String[] stringArray) {
        String[] stringArray2;
        String string = zzdnm.zzc(zzdrc2);
        String string2 = zzdnm.zzox(string);
        String[] stringArray3 = stringArray2 = new String[zzdrc2.size() + 3];
        zzdrc zzdrc3 = zzdrc2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzdrc3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzdnm.zzc(zzdrc3);
            zzdrc3 = zzdrc3.zzbtb();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzdnm.zzc(zzdrc.zzbsw());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzdrc2.size() + 1] = string;
        stringArray2[zzdrc2.size() + 2] = string2;
        String string6 = "path";
        return this.zzlpr.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzdrc zzdrc2) {
        if (zzdrc2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzdrc2.toString()).concat("/");
    }

    private static String zzox(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzdrc zzdrc2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzdnm.zzc(zzdrc2);
        String string4 = zzdnm.zzox(string3);
        return this.zzlpr.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzao(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzav(Object object) {
        try {
            return zzdzc.zzbj((Object)object).getBytes(zzfcc);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzdxx zzal(byte[] byArray) {
        try {
            return zzdya.zza(zzdzc.zzpr((String)new String(byArray, zzfcc)), zzdxo.zzbwx());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzfcc);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzq(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

