/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdnr;
import com.google.android.gms.internal.zzdns;
import com.google.android.gms.internal.zzdnv;
import com.google.android.gms.internal.zzdod;
import com.google.android.gms.internal.zzdog;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzdnq<K, V>
extends zzdns<K, V> {
    private final K[] zzlpz;
    private final V[] zzlqa;
    private final Comparator<K> zzlqb;

    public static <A, B, C> zzdnq<A, C> zza(List<A> list, Map<B, C> map, zzdnv<A, B> zzdnv2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zzdnv2.zzba(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzdnq<Object, Object>(comparator, objectArray, objectArray2);
    }

    public zzdnq(Comparator<K> comparator) {
        this.zzlpz = new Object[0];
        this.zzlqa = new Object[0];
        this.zzlqb = comparator;
    }

    private zzdnq(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzlpz = KArray;
        this.zzlqa = VArray;
        this.zzlqb = comparator;
    }

    @Override
    public final boolean containsKey(K k) {
        return this.zzaz(k) != -1;
    }

    @Override
    public final V get(K k) {
        int n = this.zzaz(k);
        if (n != -1) {
            return this.zzlqa[n];
        }
        return null;
    }

    @Override
    public final zzdns<K, V> zzaw(K k) {
        int n = this.zzaz(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzdnq.zza(this.zzlpz, n);
        V[] VArray = zzdnq.zza(this.zzlqa, n);
        return new zzdnq<K, V>(this.zzlqb, KArray, VArray);
    }

    @Override
    public final zzdns<K, V> zzg(K k, V v) {
        int n = this.zzaz(k);
        if (n != -1) {
            if (this.zzlpz[n] == k && this.zzlqa[n] == v) {
                return this;
            }
            K[] KArray = zzdnq.zzb(this.zzlpz, n, k);
            V[] VArray = zzdnq.zzb(this.zzlqa, n, v);
            return new zzdnq<K, V>(this.zzlqb, KArray, VArray);
        }
        if (this.zzlpz.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzlpz.length + 1);
            for (int i = 0; i < this.zzlpz.length; ++i) {
                hashMap.put(this.zzlpz[i], this.zzlqa[i]);
            }
            hashMap.put(k, v);
            return zzdog.zzb(hashMap, this.zzlqb);
        }
        int n2 = this.zzay(k);
        K[] KArray = zzdnq.zza(this.zzlpz, n2, k);
        V[] VArray = zzdnq.zza(this.zzlqa, n2, v);
        return new zzdnq<K, V>(this.zzlqb, KArray, VArray);
    }

    @Override
    public final K zzbpu() {
        if (this.zzlpz.length > 0) {
            return this.zzlpz[0];
        }
        return null;
    }

    @Override
    public final K zzbpv() {
        if (this.zzlpz.length > 0) {
            return this.zzlpz[this.zzlpz.length - 1];
        }
        return null;
    }

    @Override
    public final int size() {
        return this.zzlpz.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.zzlpz.length == 0;
    }

    @Override
    public final void zza(zzdod<K, V> zzdod2) {
        for (int i = 0; i < this.zzlpz.length; ++i) {
            zzdod2.zzh(this.zzlpz[i], this.zzlqa[i]);
        }
    }

    private final Iterator<Map.Entry<K, V>> zzj(int n, boolean bl) {
        return new zzdnr(this, n, bl);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return this.zzj(0, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> zzbpw() {
        return this.zzj(this.zzlpz.length - 1, true);
    }

    @Override
    public final K zzax(K k) {
        int n = this.zzaz(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        if (n > 0) {
            return this.zzlpz[n - 1];
        }
        return null;
    }

    @Override
    public final Comparator<K> getComparator() {
        return this.zzlqb;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private final int zzay(K k) {
        int n;
        for (n = 0; n < this.zzlpz.length && this.zzlqb.compare(this.zzlpz[n], k) < 0; ++n) {
        }
        return n;
    }

    private final int zzaz(K k) {
        int n = 0;
        K[] KArray = this.zzlpz;
        int n2 = this.zzlpz.length;
        for (int i = 0; i < n2; ++i) {
            K k2 = KArray[i];
            if (this.zzlqb.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static /* synthetic */ Object[] zza(zzdnq zzdnq2) {
        return zzdnq2.zzlpz;
    }

    static /* synthetic */ Object[] zzb(zzdnq zzdnq2) {
        return zzdnq2.zzlqa;
    }
}

