/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzdqr;
import com.google.android.gms.internal.zzdrc;
import com.google.android.gms.internal.zzdrf;
import com.google.android.gms.internal.zzdsi;
import com.google.android.gms.internal.zzdsj;
import com.google.android.gms.internal.zzdzm;
import com.google.android.gms.internal.zzdzo;
import com.google.android.gms.internal.zzdzq;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzdsi, FirebaseDatabase>> zzloi = new HashMap<String, Map<zzdsi, FirebaseDatabase>>();
    private final FirebaseApp zzloj;
    private final zzdsi zzlok;
    private final zzdqr zzlol;
    private zzdrf zzlom;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzdsi, FirebaseDatabase> map = zzloi.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzdsi, FirebaseDatabase>();
            zzloi.put(firebaseApp.getName(), map);
        }
        zzdzm zzdzm2 = zzdzo.zzps(string);
        if (!zzdzm2.zzlot.isEmpty()) {
            String string2 = zzdzm2.zzlot.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzdzm2.zzlok);
        if (firebaseDatabase == null) {
            zzdqr zzdqr2 = new zzdqr();
            if (!firebaseApp.zzbnn()) {
                zzdqr2.zzpm(firebaseApp.getName());
            }
            zzdqr2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzdzm2.zzlok, zzdqr2);
            map.put(zzdzm2.zzlok, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzdsi zzdsi2, zzdqr zzdqr2) {
        this.zzloj = firebaseApp;
        this.zzlok = zzdsi2;
        this.zzlol = zzdqr2;
    }

    public FirebaseApp getApp() {
        return this.zzloj;
    }

    public DatabaseReference getReference() {
        this.zzbpj();
        return new DatabaseReference(this.zzlom, zzdrc.zzbsw());
    }

    public DatabaseReference getReference(String string) {
        this.zzbpj();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzdzq.zzpx(string);
        zzdrc zzdrc2 = new zzdrc(string);
        return new DatabaseReference(this.zzlom, zzdrc2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbpj();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzdzm zzdzm2 = zzdzo.zzps(string);
        if (!zzdzm2.zzlok.host.equals(this.zzlom.zzbte().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzlom, zzdzm2.zzlot);
    }

    public void purgeOutstandingWrites() {
        this.zzbpj();
        this.zzlom.zzn(new zzg(this));
    }

    public void goOnline() {
        this.zzbpj();
        zzdsj.zzl(this.zzlom);
    }

    public void goOffline() {
        this.zzbpj();
        zzdsj.zzk(this.zzlom);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzow("setLogLevel");
        this.zzlol.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzow("setPersistenceEnabled");
        this.zzlol.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzow("setPersistenceCacheSizeBytes");
        this.zzlol.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzow(String string) {
        if (this.zzlom != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbpj() {
        if (this.zzlom == null) {
            this.zzlom = zzdsj.zza(this.zzlol, this.zzlok, this);
        }
    }

    static /* synthetic */ zzdrf zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzlom;
    }
}

