/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdqi;
import com.google.android.gms.internal.zzdqt;
import com.google.android.gms.internal.zzdrc;
import com.google.android.gms.internal.zzdrf;
import com.google.android.gms.internal.zzdtz;
import com.google.android.gms.internal.zzdue;
import com.google.android.gms.internal.zzdwb;
import com.google.android.gms.internal.zzdwe;
import com.google.android.gms.internal.zzdwz;
import com.google.android.gms.internal.zzdxa;
import com.google.android.gms.internal.zzdxn;
import com.google.android.gms.internal.zzdxo;
import com.google.android.gms.internal.zzdxr;
import com.google.android.gms.internal.zzdxx;
import com.google.android.gms.internal.zzdyb;
import com.google.android.gms.internal.zzdyc;
import com.google.android.gms.internal.zzdyd;
import com.google.android.gms.internal.zzdyf;
import com.google.android.gms.internal.zzdyh;
import com.google.android.gms.internal.zzdzo;
import com.google.android.gms.internal.zzdzq;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzdrf zzlom;
    protected final zzdrc zzlot;
    private zzdwb zzlox;
    private final boolean zzloy;

    private Query(zzdrf zzdrf2, zzdrc zzdrc2, zzdwb zzdwb2, boolean bl) throws DatabaseException {
        this.zzlom = zzdrf2;
        this.zzlot = zzdrc2;
        this.zzlox = zzdwb2;
        this.zzloy = bl;
        zzdwb zzdwb3 = zzdwb2;
        zzdzo.zzb(!zzdwb3.zzbvb() || !zzdwb3.zzbve() || !zzdwb3.zzbvh() || zzdwb3.zzbvi(), "Validation of queries failed.");
    }

    Query(zzdrf zzdrf2, zzdrc zzdrc2) {
        this.zzlom = zzdrf2;
        this.zzlot = zzdrc2;
        this.zzlox = zzdwb.zzmen;
        this.zzloy = false;
    }

    private static void zza(zzdwb zzdwb2) {
        if (zzdwb2.zzbvj().equals(zzdxr.zzbxd())) {
            zzdxx zzdxx2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzdwb2.zzbvb()) {
                zzdxx2 = zzdwb2.zzbvc();
                if (zzdwb2.zzbvd() != zzdxa.zzbwf() || !(zzdxx2 instanceof zzdyf)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzdwb2.zzbve()) {
                zzdxx2 = zzdwb2.zzbvf();
                if (zzdwb2.zzbvg() != zzdxa.zzbwg() || !(zzdxx2 instanceof zzdyf)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzdwb2.zzbvj().equals(zzdyc.zzbxh()) && (zzdwb2.zzbvb() && !zzdyd.zzl(zzdwb2.zzbvc()) || zzdwb2.zzbve() && !zzdyd.zzl(zzdwb2.zzbvf()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzdwb zzdwb2) {
        if (zzdwb2.zzbvb() && zzdwb2.zzbve() && zzdwb2.zzbvh() && !zzdwb2.zzbvi()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbpl() {
        if (this.zzlox.zzbvb()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzlox.zzbve()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbpm() {
        if (this.zzloy) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzdtz(this.zzlom, valueEventListener, this.zzbpo()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzdqi(this.zzlom, childEventListener, this.zzbpo()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzdtz(this.zzlom, new zzp(this, valueEventListener), this.zzbpo()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdtz(this.zzlom, valueEventListener, this.zzbpo()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdqi(this.zzlom, childEventListener, this.zzbpo()));
    }

    private final void zza(zzdqt zzdqt2) {
        zzdue.zzbtx().zzj(zzdqt2);
        this.zzlom.zzn(new zzq(this, zzdqt2));
    }

    private final void zzb(zzdqt zzdqt2) {
        zzdue.zzbtx().zzi(zzdqt2);
        this.zzlom.zzn(new zzr(this, zzdqt2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzlot.isEmpty() && this.zzlot.zzbsz().equals(zzdxa.zzbwi())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzlom.zzn(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzdxx zzdxx2 = string != null ? new zzdyf(string, zzdxo.zzbwx()) : zzdxo.zzbwx();
        return this.zza(zzdxx2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzdxn(d, zzdxo.zzbwx()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzdwz(bl, zzdxo.zzbwx()), string);
    }

    private final Query zza(zzdxx zzdxx2, String string) {
        zzdzq.zzpy(string);
        if (!zzdxx2.zzbwm() && !zzdxx2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzlox.zzbvb()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzdxa zzdxa2 = string != null ? zzdxa.zzpo(string) : null;
        zzdwb zzdwb2 = this.zzlox.zza(zzdxx2, zzdxa2);
        Query.zzb(zzdwb2);
        Query.zza(zzdwb2);
        return new Query(this.zzlom, this.zzlot, zzdwb2, this.zzloy);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzdxx zzdxx2 = string != null ? new zzdyf(string, zzdxo.zzbwx()) : zzdxo.zzbwx();
        return this.zzb(zzdxx2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzdxn(d, zzdxo.zzbwx()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzdwz(bl, zzdxo.zzbwx()), string);
    }

    private final Query zzb(zzdxx zzdxx2, String string) {
        zzdxa zzdxa2;
        zzdzq.zzpy(string);
        if (!zzdxx2.zzbwm() && !zzdxx2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzdxa zzdxa3 = zzdxa2 = string != null ? zzdxa.zzpo(string) : null;
        if (this.zzlox.zzbve()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzdwb zzdwb2 = this.zzlox.zzb(zzdxx2, zzdxa2);
        Query.zzb(zzdwb2);
        Query.zza(zzdwb2);
        return new Query(this.zzlom, this.zzlot, zzdwb2, this.zzloy);
    }

    public Query equalTo(String string) {
        this.zzbpl();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbpl();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbpl();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbpl();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbpl();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbpl();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlox.zzbvh()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzlom, this.zzlot, this.zzlox.zzfv(n), this.zzloy);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlox.zzbvh()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzlom, this.zzlot, this.zzlox.zzfw(n), this.zzloy);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzdzq.zzpw(string);
        this.zzbpm();
        zzdrc zzdrc2 = new zzdrc(string);
        if (zzdrc2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzdyb zzdyb2 = new zzdyb(zzdrc2);
        return new Query(this.zzlom, this.zzlot, this.zzlox.zza(zzdyb2), true);
    }

    public Query orderByPriority() {
        this.zzbpm();
        zzdwb zzdwb2 = this.zzlox.zza(zzdyc.zzbxh());
        Query.zza(zzdwb2);
        return new Query(this.zzlom, this.zzlot, zzdwb2, true);
    }

    public Query orderByKey() {
        this.zzbpm();
        zzdwb zzdwb2 = this.zzlox.zza(zzdxr.zzbxd());
        Query.zza(zzdwb2);
        return new Query(this.zzlom, this.zzlot, zzdwb2, true);
    }

    public Query orderByValue() {
        this.zzbpm();
        return new Query(this.zzlom, this.zzlot, this.zzlox.zza(zzdyh.zzbxi()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzlom, this.zzlot);
    }

    public final zzdrc zzbpn() {
        return this.zzlot;
    }

    public final zzdwe zzbpo() {
        return new zzdwe(this.zzlot, this.zzlox);
    }
}

